/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Logger;

class FormattedLogger
extends AbstractPrintWriterLogger {
    static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ");
    static final Function<ZoneId, ZonedDateTime> DEFAULT_CURRENT_DATE_TIME = zoneId -> ZonedDateTime.now().withZoneSameInstant((ZoneId)zoneId);
    private FormattedLog formattedLog;
    private final String prefix;
    private final DateTimeFormatter dateTimeFormatter;
    private Supplier<ZonedDateTime> supplier;

    FormattedLogger(FormattedLog formattedLog, @Nonnull Supplier<PrintWriter> writerSupplier, @Nonnull String prefix, DateTimeFormatter dateTimeFormatter, Supplier<ZonedDateTime> zonedDateTimeSupplier) {
        super(writerSupplier, formattedLog.lock, formattedLog.autoFlush);
        this.formattedLog = formattedLog;
        this.prefix = prefix;
        this.dateTimeFormatter = dateTimeFormatter;
        this.supplier = zonedDateTimeSupplier;
    }

    @Override
    protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message) {
        this.lineStart(out);
        out.write(message);
        out.println();
    }

    @Override
    protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message, @Nonnull Throwable throwable) {
        this.lineStart(out);
        out.write(message);
        if (throwable.getMessage() != null) {
            out.write(32);
            out.write(throwable.getMessage());
        }
        out.println();
        throwable.printStackTrace(out);
    }

    @Override
    protected Logger getBulkLogger(@Nonnull PrintWriter out, @Nonnull Object lock) {
        return new FormattedLogger(this.formattedLog, Suppliers.singleton((Object)out), this.prefix, DATE_TIME_FORMATTER, () -> DEFAULT_CURRENT_DATE_TIME.apply(this.formattedLog.zoneId));
    }

    private void lineStart(PrintWriter out) {
        out.write(this.time());
        out.write(32);
        out.write(this.prefix);
        out.write(32);
    }

    private String time() {
        return this.dateTimeFormatter.format(this.supplier.get());
    }
}

