/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;
import org.neo4j.logging.Log;

public class CappedLogger {
    private final Log delegate;
    private volatile Filter filter = new Filter();

    public CappedLogger(@Nonnull Log delegate) {
        this.delegate = delegate;
    }

    public void debug(@Nonnull String msg) {
        if (this.filter.accept()) {
            this.delegate.debug(msg);
        }
    }

    public void debug(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.filter.accept()) {
            this.delegate.debug(msg, cause);
        }
    }

    public void info(@Nonnull String msg, Object ... arguments) {
        if (this.filter.accept()) {
            this.delegate.info(msg, arguments);
        }
    }

    public void info(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.filter.accept()) {
            this.delegate.info(msg, cause);
        }
    }

    public void warn(@Nonnull String msg) {
        if (this.filter.accept()) {
            this.delegate.warn(msg);
        }
    }

    public void warn(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.filter.accept()) {
            this.delegate.warn(msg, cause);
        }
    }

    public void warn(@Nonnull String msg, Object ... arguments) {
        if (this.filter.accept()) {
            this.delegate.warn(msg, arguments);
        }
    }

    public void error(@Nonnull String msg) {
        if (this.filter.accept()) {
            this.delegate.error(msg);
        }
    }

    public void error(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.filter.accept()) {
            this.delegate.error(msg, cause);
        }
    }

    public void reset() {
        this.filter = this.filter.reset();
    }

    public CappedLogger setCountLimit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("The count limit must be positive");
        }
        this.filter = this.filter.setCountLimit(limit);
        return this;
    }

    public CappedLogger unsetCountLimit() {
        this.filter = this.filter.unsetCountLimit();
        return this;
    }

    public CappedLogger setTimeLimit(long time, @Nonnull TimeUnit unit, @Nonnull Clock clock) {
        if (time < 1L) {
            throw new IllegalArgumentException("The time limit must be positive");
        }
        this.filter = this.filter.setTimeLimit(time, unit, clock);
        return this;
    }

    public CappedLogger unsetTimeLimit() {
        this.filter = this.filter.unsetTimeLimit();
        return this;
    }

    private static class Filter {
        private static final AtomicIntegerFieldUpdater<Filter> CURRENT_COUNT = AtomicIntegerFieldUpdater.newUpdater(Filter.class, "currentCount");
        private static final AtomicLongFieldUpdater<Filter> LAST_CHECK = AtomicLongFieldUpdater.newUpdater(Filter.class, "lastCheck");
        private boolean hasCountLimit;
        private int countLimit;
        private long timeLimitMillis;
        private final Clock clock;
        private volatile int currentCount;
        private volatile long lastCheck;

        private Filter() {
            this(false, 0, 0, 0L, 0L, null);
        }

        private Filter(boolean hasCountLimit, int countLimit, int currentCount, long timeLimitMillis, long lastCheck, Clock clock) {
            this.hasCountLimit = hasCountLimit;
            this.countLimit = countLimit;
            this.currentCount = currentCount;
            this.timeLimitMillis = timeLimitMillis;
            this.lastCheck = lastCheck;
            this.clock = clock;
        }

        public Filter setCountLimit(int limit) {
            return new Filter(true, limit, this.currentCount, this.timeLimitMillis, this.lastCheck, this.clock);
        }

        public boolean accept() {
            return !(this.hasCountLimit && this.getAndIncrementCurrentCount() >= this.countLimit || this.clock != null && this.checkExpiredAndSetLastCheckTime());
        }

        public int getAndIncrementCurrentCount() {
            return CURRENT_COUNT.getAndIncrement(this);
        }

        private boolean checkExpiredAndSetLastCheckTime() {
            long check = this.lastCheck;
            long now = this.clock.millis();
            if (check > now - this.timeLimitMillis) {
                return true;
            }
            while (!LAST_CHECK.compareAndSet(this, check, now) && (check = this.lastCheck) <= now) {
            }
            return false;
        }

        public Filter reset() {
            return new Filter(this.hasCountLimit, this.countLimit, 0, this.timeLimitMillis, 0L, this.clock);
        }

        public Filter unsetCountLimit() {
            return new Filter(false, 0, this.currentCount, this.timeLimitMillis, this.lastCheck, this.clock);
        }

        public Filter setTimeLimit(long time, @Nonnull TimeUnit unit, @Nonnull Clock clock) {
            return new Filter(this.hasCountLimit, this.countLimit, this.currentCount, unit.toMillis(time), this.lastCheck, clock);
        }

        public Filter unsetTimeLimit() {
            return new Filter(this.hasCountLimit, this.countLimit, this.currentCount, 0L, this.lastCheck, null);
        }
    }
}

