/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class DuplicatingLog
extends AbstractLog {
    private final CopyOnWriteArraySet<Log> logs;
    private final DuplicatingLogger debugLogger;
    private final DuplicatingLogger infoLogger;
    private final DuplicatingLogger warnLogger;
    private final DuplicatingLogger errorLogger;

    public DuplicatingLog(Log ... logs) {
        this(Arrays.asList(logs));
    }

    public DuplicatingLog(List<Log> logs) {
        ArrayList<Supplier<Logger>> debugLoggers = new ArrayList<Supplier<Logger>>(logs.size());
        ArrayList<Supplier<Logger>> infoLoggers = new ArrayList<Supplier<Logger>>(logs.size());
        ArrayList<Supplier<Logger>> warnLoggers = new ArrayList<Supplier<Logger>>(logs.size());
        ArrayList<Supplier<Logger>> errorLoggers = new ArrayList<Supplier<Logger>>(logs.size());
        for (Log log : logs) {
            debugLoggers.add(log::debugLogger);
            infoLoggers.add(log::infoLogger);
            warnLoggers.add(log::warnLogger);
            errorLoggers.add(log::errorLogger);
        }
        this.logs = new CopyOnWriteArraySet<Log>(logs);
        this.debugLogger = new DuplicatingLogger(debugLoggers);
        this.infoLogger = new DuplicatingLogger(infoLoggers);
        this.warnLogger = new DuplicatingLogger(warnLoggers);
        this.errorLogger = new DuplicatingLogger(errorLoggers);
    }

    @Override
    public boolean isDebugEnabled() {
        for (Log log : this.logs) {
            if (!log.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.debugLogger;
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.infoLogger;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.warnLogger;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.errorLogger;
    }

    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        DuplicatingLog.bulk(new ArrayDeque<Log>(this.logs), new ArrayList<Log>(this.logs.size()), consumer);
    }

    private static void bulk(Deque<Log> remaining, List<Log> bulkLogs, Consumer<Log> finalConsumer) {
        if (!remaining.isEmpty()) {
            Log log = remaining.pop();
            log.bulk(bulkLog -> {
                bulkLogs.add((Log)bulkLog);
                DuplicatingLog.bulk(remaining, bulkLogs, finalConsumer);
            });
        } else {
            DuplicatingLog log = new DuplicatingLog(bulkLogs);
            finalConsumer.accept(log);
        }
    }

    private static class DuplicatingLogger
    implements Logger {
        private final CopyOnWriteArraySet<Supplier<Logger>> loggers;

        DuplicatingLogger(List<Supplier<Logger>> loggers) {
            this.loggers = new CopyOnWriteArraySet<Supplier<Logger>>(loggers);
        }

        @Override
        public void log(@Nonnull String message) {
            for (Supplier<Logger> logger : this.loggers) {
                logger.get().log(message);
            }
        }

        @Override
        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            for (Supplier<Logger> logger : this.loggers) {
                logger.get().log(message, throwable);
            }
        }

        @Override
        public void log(@Nonnull String format, Object ... arguments) {
            for (Supplier<Logger> logger : this.loggers) {
                logger.get().log(format, arguments);
            }
        }

        @Override
        public void bulk(@Nonnull Consumer<Logger> consumer) {
            DuplicatingLogger.bulk(new ArrayDeque<Supplier<Logger>>(this.loggers), new ArrayList<Supplier<Logger>>(this.loggers.size()), consumer);
        }

        private static void bulk(Deque<Supplier<Logger>> remaining, List<Supplier<Logger>> bulkLoggers, Consumer<Logger> finalConsumer) {
            if (!remaining.isEmpty()) {
                Logger logger = remaining.pop().get();
                logger.bulk(bulkLogger -> {
                    bulkLoggers.add(() -> bulkLogger);
                    DuplicatingLogger.bulk(remaining, bulkLoggers, finalConsumer);
                });
            } else {
                DuplicatingLogger logger = new DuplicatingLogger(bulkLoggers);
                finalConsumer.accept(logger);
            }
        }
    }
}

