/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.Closeable;
import org.neo4j.io.IOUtils;
import org.neo4j.logging.log4j.Log4jPluginLoadingWorkaround;
import org.neo4j.logging.shaded.log4j.LogManager;
import org.neo4j.logging.shaded.log4j.core.Logger;
import org.neo4j.logging.shaded.log4j.core.LoggerContext;

public class Neo4jLoggerContext
implements Closeable {
    private final LoggerContext ctx;
    private final Closeable additionalClosable;

    public Neo4jLoggerContext(LoggerContext ctx, Closeable additionalClosable) {
        this.ctx = ctx;
        this.additionalClosable = additionalClosable;
    }

    Logger getLogger(String name) {
        return this.ctx.getLogger(name);
    }

    LoggerContext getLoggerContext() {
        return this.ctx;
    }

    boolean haveExternalResources() {
        return this.additionalClosable != null;
    }

    @Override
    public void close() {
        LogManager.shutdown(this.ctx);
        if (this.additionalClosable != null) {
            IOUtils.closeAllSilently((AutoCloseable[])new Closeable[]{this.additionalClosable});
        }
    }

    static {
        Log4jPluginLoadingWorkaround.doLog4jPluginLoadingWorkaround();
    }
}

