/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.Closeable;
import java.io.OutputStream;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLog;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public class Log4jLogProvider
implements LogProvider,
Closeable {
    private final Neo4jLoggerContext ctx;

    public Log4jLogProvider(Neo4jLoggerContext ctx) {
        this.ctx = ctx;
    }

    public Log4jLogProvider(OutputStream out) {
        this(out, Level.INFO);
    }

    public Log4jLogProvider(OutputStream out, Level level) {
        this(LogConfig.createBuilder(out, level).build());
    }

    public void updateLogLevel(Level newLevel) {
        LogConfig.updateLogLevel(newLevel, this.ctx);
    }

    @Override
    public Log getLog(Class<?> loggingClass) {
        return new Log4jLog(this.ctx.getLogger(loggingClass.getName()));
    }

    @Override
    public Log getLog(String name) {
        return new Log4jLog(this.ctx.getLogger(name));
    }

    @Override
    public void close() {
        this.ctx.close();
    }
}

