/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.shaded.log4j.core.lookup;

import org.neo4j.logging.shaded.log4j.Logger;
import org.neo4j.logging.shaded.log4j.Marker;
import org.neo4j.logging.shaded.log4j.MarkerManager;
import org.neo4j.logging.shaded.log4j.core.LogEvent;
import org.neo4j.logging.shaded.log4j.core.config.plugins.Plugin;
import org.neo4j.logging.shaded.log4j.core.lookup.AbstractLookup;
import org.neo4j.logging.shaded.log4j.status.StatusLogger;

@Plugin(name="sys", category="Lookup")
public class SystemPropertiesLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Marker LOOKUP = MarkerManager.getMarker("LOOKUP");

    @Override
    public String lookup(LogEvent event, String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception ex) {
            LOGGER.warn(LOOKUP, "Error while getting system property [{}].", (Object)key, (Object)ex);
            return null;
        }
    }
}

