/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.Neo4jMessageSupplier;
import org.neo4j.logging.log4j.LoggerTarget;

public class ExternalLogProviderWrapper
implements InternalLogProvider {
    private final LogProvider delegate;

    public ExternalLogProviderWrapper(LogProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public InternalLog getLog(Class<?> loggingClass) {
        return new ExternalLogWrapper(this.delegate.getLog(loggingClass));
    }

    @Override
    public InternalLog getLog(String name) {
        return new ExternalLogWrapper(this.delegate.getLog(name));
    }

    @Override
    public InternalLog getLog(LoggerTarget target) {
        return new ExternalLogWrapper(this.delegate.getLog(target.getTarget()));
    }

    private static class ExternalLogWrapper
    implements InternalLog {
        private final Log delegate;

        ExternalLogWrapper(Log delegate) {
            this.delegate = delegate;
        }

        @Override
        public void debug(Neo4jLogMessage message) {
            this.delegate.debug(message.getFormattedMessage());
        }

        @Override
        public void debug(Neo4jMessageSupplier supplier) {
            this.delegate.debug(supplier.get().getFormattedMessage());
        }

        @Override
        public void info(Neo4jLogMessage message) {
            this.delegate.info(message.getFormattedMessage());
        }

        @Override
        public void info(Neo4jMessageSupplier supplier) {
            this.delegate.info(supplier.get().getFormattedMessage());
        }

        @Override
        public void warn(Neo4jLogMessage message) {
            this.delegate.warn(message.getFormattedMessage());
        }

        @Override
        public void warn(Neo4jMessageSupplier supplier) {
            this.delegate.warn(supplier.get().getFormattedMessage());
        }

        @Override
        public void error(Neo4jLogMessage message) {
            this.delegate.error(message.getFormattedMessage());
        }

        @Override
        public void error(Neo4jMessageSupplier supplier) {
            this.delegate.error(supplier.get().getFormattedMessage());
        }

        @Override
        public void error(Neo4jLogMessage message, Throwable throwable) {
            this.delegate.error(message.getFormattedMessage(), throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        @Override
        public void debug(String message) {
            this.delegate.debug(message);
        }

        @Override
        public void debug(String message, Throwable throwable) {
            this.delegate.debug(message, throwable);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.delegate.debug(format, arguments);
        }

        @Override
        public void info(String message) {
            this.delegate.info(message);
        }

        @Override
        public void info(String message, Throwable throwable) {
            this.delegate.info(message, throwable);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.delegate.info(format, arguments);
        }

        @Override
        public void warn(String message) {
            this.delegate.warn(message);
        }

        @Override
        public void warn(String message, Throwable throwable) {
            this.delegate.warn(message, throwable);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.delegate.warn(format, arguments);
        }

        @Override
        public void error(String message) {
            this.delegate.error(message);
        }

        @Override
        public void error(String message, Throwable throwable) {
            this.delegate.error(message, throwable);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.delegate.error(format, arguments);
        }
    }
}

