/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public final class LogUtils {
    private LogUtils() {
    }

    public static Log4jXmlConfigBuilder newTemporaryXmlConfigBuilder(FileSystemAbstraction fileSystem) {
        try {
            return new Log4jXmlConfigBuilder(fileSystem, fileSystem.createTempFile("log4j-", ".xml"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Log4jXmlConfigBuilder newXmlConfigBuilder(FileSystemAbstraction fileSystemAbstraction, Path xmlConfig) {
        return new Log4jXmlConfigBuilder(fileSystemAbstraction, xmlConfig);
    }

    public static Log4jXmlLoggerBuilder newLoggerBuilder(LoggerTarget target, Path filename) {
        return new Log4jXmlLoggerBuilder(target, filename);
    }

    public static final class Log4jXmlConfigBuilder {
        private final FileSystemAbstraction fileSystem;
        private final Path xmlConfig;
        private final List<XmlLogger> loggers = new ArrayList<XmlLogger>();

        private Log4jXmlConfigBuilder(FileSystemAbstraction fileSystem, Path xmlConfig) {
            this.fileSystem = fileSystem;
            this.xmlConfig = xmlConfig;
        }

        public Log4jXmlConfigBuilder withLogger(XmlLogger logger) {
            this.loggers.add(logger);
            return this;
        }

        public Path create() {
            StringBuilder sb = new StringBuilder();
            sb.append("<Configuration>\n");
            sb.append("  <Appenders>\n");
            this.createAppender(sb);
            sb.append("  </Appenders>\n");
            sb.append("    <Loggers>\n");
            for (XmlLogger logger : this.loggers) {
                if (logger.target.equals((Object)LoggerTarget.ROOT_LOGGER)) {
                    sb.append("      <Root level=\"").append(logger.level).append("\">\n");
                    sb.append("        <AppenderRef ref=\"appender-").append(logger.target.getTarget()).append("\"/>\n");
                    sb.append("      </Root>\n");
                    continue;
                }
                sb.append("      <Logger name=\"").append(logger.target.getTarget()).append("\" additivity=\"false\" level=\"").append(logger.level).append("\">\n");
                sb.append("        <AppenderRef ref=\"appender-").append(logger.target.getTarget()).append("\"/>\n");
                sb.append("      </Logger>\n");
            }
            sb.append("    </Loggers>\n");
            sb.append("</Configuration>\n");
            byte[] xmlContent = sb.toString().getBytes(StandardCharsets.UTF_8);
            try {
                this.fileSystem.mkdirs(this.xmlConfig.getParent());
                StoreChannel channel = this.fileSystem.open(this.xmlConfig, Set.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
                try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(xmlContent.length, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                    ByteBuffer buffer = scopedBuffer.getBuffer();
                    buffer.put(xmlContent);
                    buffer.flip();
                    channel.writeAll(buffer);
                }
                return this.xmlConfig;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void createAppender(StringBuilder sb) {
            for (XmlLogger logger : this.loggers) {
                String appender = "RollingRandomAccessFile";
                if (logger.createOnDemand) {
                    appender = "RollingFile";
                }
                sb.append("    <").append(appender).append(" name=\"appender-").append(logger.target.getTarget()).append("\" fileName=\"").append(logger.filename.toAbsolutePath()).append("\" filePattern=\"").append(logger.filename.toAbsolutePath()).append(".%02i\"");
                if (logger.createOnDemand) {
                    sb.append(" createOnDemand=\"true\"");
                }
                sb.append(">\n");
                if (logger.jsonLayout != null) {
                    sb.append("      <JsonTemplateLayout eventTemplateUri=\"").append(logger.jsonLayout).append("\" />\n");
                } else if (logger.forDebugLog) {
                    sb.append("      <Neo4jDebugLogLayout pattern=\"").append(logger.getPattern()).append("\"/>\n");
                } else {
                    sb.append("      <PatternLayout pattern=\"").append(logger.getPattern()).append("\"/>\n");
                }
                sb.append("      <Policies>\n");
                sb.append("        <SizeBasedTriggeringPolicy size=\"").append(logger.rotationThreshold).append(" B\"/>\n");
                sb.append("      </Policies>\n");
                sb.append("      <DefaultRolloverStrategy fileIndex=\"min\" max=\"").append(logger.maxArchives).append("\"/>\n");
                sb.append("    </").append(appender).append(">\n");
            }
        }
    }

    public static class Log4jXmlLoggerBuilder {
        private final LoggerTarget target;
        private final Path filename;
        private String level = "info";
        private boolean createOnDemand;
        private LogTimeZone timezone = LogTimeZone.UTC;
        private boolean includeCategory = true;
        private String jsonLayout;
        private long rotationThreshold = ByteUnit.mebiBytes((long)20L);
        private int maxArchives = 7;
        private boolean forDebugLog = false;

        Log4jXmlLoggerBuilder(LoggerTarget target, Path filename) {
            this.target = target;
            this.filename = filename;
        }

        public Log4jXmlLoggerBuilder withLevel(String level) {
            this.level = level;
            return this;
        }

        public Log4jXmlLoggerBuilder withLevel(Level level) {
            this.level = LogConfig.convertNeo4jLevelToLevel(level).toString();
            return this;
        }

        public Log4jXmlLoggerBuilder withRotation(long rotationThreshold, int maxArchives) {
            this.rotationThreshold = rotationThreshold;
            this.maxArchives = maxArchives;
            return this;
        }

        public Log4jXmlLoggerBuilder createOnDemand() {
            this.createOnDemand = true;
            return this;
        }

        public Log4jXmlLoggerBuilder withCategory(boolean includeCategory) {
            this.includeCategory = includeCategory;
            return this;
        }

        public Log4jXmlLoggerBuilder withJsonFormatTemplate(String templateUri) {
            this.jsonLayout = templateUri;
            return this;
        }

        public Log4jXmlLoggerBuilder forDebugLog(boolean forDebugLog) {
            this.forDebugLog = forDebugLog;
            return this;
        }

        public Log4jXmlLoggerBuilder withTimezone(LogTimeZone timezone) {
            this.timezone = timezone;
            return this;
        }

        public XmlLogger build() {
            return new XmlLogger(this.target, this.filename, this.level, this.createOnDemand, this.timezone, this.includeCategory, this.jsonLayout, this.rotationThreshold, this.maxArchives, this.forDebugLog);
        }
    }

    record XmlLogger(LoggerTarget target, Path filename, String level, boolean createOnDemand, LogTimeZone timezone, boolean includeCategory, String jsonLayout, long rotationThreshold, int maxArchives, boolean forDebugLog) {
        private String getPattern() {
            return LogConfig.getFormatPattern(this.includeCategory, this.timezone);
        }
    }
}

