/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.index.impl.lucene.FullTxData;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneTransaction;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.index.impl.lucene.TxData;
import org.neo4j.index.impl.lucene.TxDataHolder;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;

public class ExactTxData
extends TxData {
    private Map<String, Map<Object, Set<Object>>> data;
    private boolean hasOrphans;

    ExactTxData(LuceneIndex index) {
        super(index);
    }

    @Override
    void add(TxDataHolder holder, Object entityId, String key, Object value) {
        this.idCollection(key, value, true).add(entityId);
    }

    private Set<Object> idCollection(String key, Object value, boolean create) {
        Map<Object, Set<Object>> keyMap = this.keyMap(key, create);
        if (keyMap == null) {
            return null;
        }
        Set<Object> ids = keyMap.get(value);
        if (ids == null && create) {
            ids = new HashSet<Object>();
            keyMap.put(value, ids);
            if (value == null) {
                this.hasOrphans = true;
            }
        }
        return ids;
    }

    private Map<Object, Set<Object>> keyMap(String key, boolean create) {
        Map<Object, Set<Object>> inner;
        if (this.data == null) {
            if (create) {
                this.data = new HashMap<String, Map<Object, Set<Object>>>();
            } else {
                return null;
            }
        }
        if ((inner = this.data.get(key)) == null && create) {
            inner = new HashMap<Object, Set<Object>>();
            this.data.put(key, inner);
            if (key == null) {
                this.hasOrphans = true;
            }
        }
        return inner;
    }

    private TxData toFullTxData() {
        FullTxData data = new FullTxData(this.index);
        if (this.data != null) {
            for (Map.Entry<String, Map<Object, Set<Object>>> entry : this.data.entrySet()) {
                String key = entry.getKey();
                for (Map.Entry<Object, Set<Object>> valueEntry : entry.getValue().entrySet()) {
                    Object value = valueEntry.getKey();
                    for (Object id : valueEntry.getValue()) {
                        data.add(null, id, key, value);
                    }
                }
            }
        }
        return data;
    }

    @Override
    void close() {
    }

    @Override
    Collection<Long> query(TxDataHolder holder, Query query, QueryContext contextOrNull) {
        if (contextOrNull != null && contextOrNull.getTradeCorrectnessForSpeed()) {
            return Collections.emptyList();
        }
        TxData fullTxData = this.toFullTxData();
        holder.set(fullTxData);
        return fullTxData.query(holder, query, contextOrNull);
    }

    @Override
    void remove(TxDataHolder holder, Object entityId, String key, Object value) {
        if (this.data == null) {
            return;
        }
        if (key == null || value == null) {
            TxData fullData = this.toFullTxData();
            fullData.remove(holder, entityId, key, value);
            holder.set(fullData);
        } else {
            Set<Object> ids = this.idCollection(key, value, false);
            if (ids != null) {
                ids.remove(entityId);
            }
        }
    }

    @Override
    Collection<Long> get(TxDataHolder holder, String key, Object value) {
        Set<Object> ids = this.idCollection(key, value = value instanceof ValueContext ? ((ValueContext)value).getCorrectValue() : value.toString(), false);
        if (ids == null || ids.isEmpty()) {
            return Collections.emptySet();
        }
        return this.toLongs(ids);
    }

    @Override
    Collection<Long> getOrphans(String key) {
        if (!this.hasOrphans) {
            return null;
        }
        Set<Object> orphans = this.idCollection(null, null, false);
        Set<Object> keyOrphans = this.idCollection(key, null, false);
        Collection<Long> orphanLongs = orphans != null ? this.toLongs(orphans) : null;
        Collection<Long> keyOrphanLongs = keyOrphans != null ? this.toLongs(keyOrphans) : null;
        return LuceneTransaction.merge(orphanLongs, keyOrphanLongs);
    }

    private Collection<Long> toLongs(Set<Object> ids) {
        if (ids.isEmpty()) {
            return Collections.emptySet();
        }
        if (ids.iterator().next() instanceof Long) {
            return ids;
        }
        ArrayList<Long> longs = new ArrayList<Long>(ids.size());
        for (Object id : ids) {
            longs.add(((RelationshipId)id).id);
        }
        return longs;
    }

    @Override
    IndexSearcher asSearcher(TxDataHolder holder, QueryContext context) {
        if (context != null && context.getTradeCorrectnessForSpeed()) {
            return null;
        }
        TxData fullTxData = this.toFullTxData();
        holder.set(fullTxData);
        return fullTxData.asSearcher(holder, context);
    }
}

