/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.neo4j.kernel.api.direct.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.direct.NodeLabelRange;
import org.neo4j.kernel.api.impl.index.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.index.LuceneNodeLabelRange;
import org.neo4j.kernel.api.impl.index.bitmaps.Bitmap;

public class LuceneAllEntriesLabelScanReader
implements AllEntriesLabelScanReader {
    private final BitmapDocumentFormat format;
    private final BoundedIterable<Document> documents;

    public LuceneAllEntriesLabelScanReader(BoundedIterable<Document> documents, BitmapDocumentFormat format) {
        this.documents = documents;
        this.format = format;
    }

    public Iterator<NodeLabelRange> iterator() {
        final Iterator iterator = this.documents.iterator();
        return new Iterator<NodeLabelRange>(){
            private int id = 0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public LuceneNodeLabelRange next() {
                return LuceneAllEntriesLabelScanReader.this.parse(this.id++, (Document)iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public void close() throws IOException {
        this.documents.close();
    }

    public long maxCount() {
        return this.documents.maxCount();
    }

    private LuceneNodeLabelRange parse(int id, Document document) {
        List fields = document.getFields();
        long[] labelIds = new long[fields.size() - 1];
        Bitmap[] bitmaps = new Bitmap[fields.size() - 1];
        int i = 0;
        long rangeId = -1L;
        for (Fieldable field : fields) {
            if (this.format.isRangeField(field)) {
                rangeId = this.format.rangeOf(field);
                continue;
            }
            labelIds[i] = this.format.labelId(field);
            bitmaps[i] = this.format.readBitmap(field);
            ++i;
        }
        assert (rangeId >= 0L);
        return LuceneNodeLabelRange.fromBitmapStructure(id, labelIds, this.getLongs(bitmaps, rangeId));
    }

    private long[][] getLongs(Bitmap[] bitmaps, long rangeId) {
        long[][] nodeIds = new long[bitmaps.length][];
        for (int k = 0; k < nodeIds.length; ++k) {
            nodeIds[k] = this.format.bitmapFormat().convertRangeAndBitmapToArray(rangeId, bitmaps[k].bitmap());
        }
        return nodeIds;
    }
}

