/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.index.impl.lucene.EntityId;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.TxDataHolder;
import org.neo4j.index.lucene.QueryContext;

class LuceneTransactionState
implements Closeable {
    private final Map<IndexIdentifier, TxDataBoth> txData = new HashMap<IndexIdentifier, TxDataBoth>();

    LuceneTransactionState() {
    }

    void add(LuceneIndex index, EntityId entity, String key, Object value) {
        TxDataBoth data = this.getTxData(index, true);
        this.insert(entity, key, value, data.added(true), data.removed(false));
    }

    TxDataBoth getTxData(LuceneIndex index, boolean createIfNotExists) {
        IndexIdentifier identifier = index.getIdentifier();
        TxDataBoth data = this.txData.get(identifier);
        if (data == null && createIfNotExists) {
            data = new TxDataBoth(index);
            this.txData.put(identifier, data);
        }
        return data;
    }

    void remove(LuceneIndex index, EntityId entity, String key, Object value) {
        TxDataBoth data = this.getTxData(index, true);
        this.insert(entity, key, value, data.removed(true), data.added(false));
    }

    void remove(LuceneIndex index, EntityId entity, String key) {
        TxDataBoth data = this.getTxData(index, true);
        this.insert(entity, key, null, data.removed(true), data.added(false));
    }

    void remove(LuceneIndex index, EntityId entity) {
        TxDataBoth data = this.getTxData(index, true);
        this.insert(entity, null, null, data.removed(true), data.added(false));
    }

    void delete(LuceneIndex index) {
        IndexIdentifier identifier = index.getIdentifier();
        this.txData.put(identifier, new DeletedTxDataBoth(index));
    }

    private void insert(EntityId entity, String key, Object value, TxDataHolder insertInto, TxDataHolder removeFrom) {
        if (removeFrom != null) {
            removeFrom.remove(entity, key, value);
        }
        insertInto.add(entity, key, value);
    }

    Collection<EntityId> getRemovedIds(LuceneIndex index, Query query) {
        TxDataHolder removed = this.removedTxDataOrNull(index);
        if (removed == null) {
            return Collections.emptySet();
        }
        Collection<EntityId> ids = removed.query(query, null);
        return ids != null ? ids : Collections.emptySet();
    }

    Collection<EntityId> getRemovedIds(LuceneIndex index, String key, Object value) {
        TxDataHolder removed = this.removedTxDataOrNull(index);
        if (removed == null) {
            return Collections.emptySet();
        }
        Collection<EntityId> ids = removed.get(key, value);
        Collection<EntityId> orphanIds = removed.getOrphans(key);
        return LuceneTransactionState.merge(ids, orphanIds);
    }

    static Collection<EntityId> merge(Collection<EntityId> c1, Collection<EntityId> c2) {
        if (c1 == null && c2 == null) {
            return Collections.emptySet();
        }
        if (c1 != null && c2 != null) {
            if (c1.isEmpty()) {
                return c2;
            }
            if (c2.isEmpty()) {
                return c1;
            }
            HashSet<EntityId> result = new HashSet<EntityId>(c1.size() + c2.size(), 1.0f);
            result.addAll(c1);
            result.addAll(c2);
            return result;
        }
        return c1 != null ? c1 : c2;
    }

    Collection<EntityId> getAddedIds(LuceneIndex index, String key, Object value) {
        TxDataHolder added = this.addedTxDataOrNull(index);
        if (added == null) {
            return Collections.emptySet();
        }
        Collection<EntityId> ids = added.get(key, value);
        return ids != null ? ids : Collections.emptySet();
    }

    TxDataHolder addedTxDataOrNull(LuceneIndex index) {
        TxDataBoth data = this.getTxData(index, false);
        return data != null ? data.added(false) : null;
    }

    TxDataHolder removedTxDataOrNull(LuceneIndex index) {
        TxDataBoth data = this.getTxData(index, false);
        return data != null ? data.removed(false) : null;
    }

    @Override
    public void close() {
        for (TxDataBoth data : this.txData.values()) {
            data.close();
        }
        this.txData.clear();
    }

    IndexSearcher getAdditionsAsSearcher(LuceneIndex index, QueryContext context) {
        TxDataHolder data = this.addedTxDataOrNull(index);
        return data != null ? data.asSearcher(context) : null;
    }

    private class DeletedTxDataBoth
    extends TxDataBoth {
        public DeletedTxDataBoth(LuceneIndex index) {
            super(index);
        }

        @Override
        TxDataHolder added(boolean createIfNotExists) {
            throw this.illegalStateException();
        }

        @Override
        TxDataHolder removed(boolean createIfNotExists) {
            throw this.illegalStateException();
        }

        private IllegalStateException illegalStateException() {
            throw new IllegalStateException("This index (" + this.index.getIdentifier() + ") has been marked as deleted in this transaction");
        }
    }

    private class TxDataBoth {
        private TxDataHolder add;
        private TxDataHolder remove;
        final LuceneIndex index;

        public TxDataBoth(LuceneIndex index) {
            this.index = index;
        }

        TxDataHolder added(boolean createIfNotExists) {
            if (this.add == null && createIfNotExists) {
                this.add = new TxDataHolder(this.index, this.index.type.newTxData(this.index));
            }
            return this.add;
        }

        TxDataHolder removed(boolean createIfNotExists) {
            if (this.remove == null && createIfNotExists) {
                this.remove = new TxDataHolder(this.index, this.index.type.newTxData(this.index));
            }
            return this.remove;
        }

        void close() {
            this.safeClose(this.add);
            this.safeClose(this.remove);
        }

        private void safeClose(TxDataHolder data) {
            if (data != null) {
                data.close();
            }
        }
    }
}

