/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Fieldable;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.api.index.util.FailureStorage;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.register.Register;

class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    static final int DEFAULT_QUEUE_THRESHOLD = 10000;
    private final int queueThreshold;
    private final NonUniqueIndexSampler sampler;
    private final List<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();

    NonUniqueLuceneIndexPopulator(int queueThreshold, LuceneDocumentStructure documentStructure, IndexWriterFactory<LuceneIndexWriter> indexWriterFactory, DirectoryFactory dirFactory, File dirFile, FailureStorage failureStorage, long indexId, IndexSamplingConfig samplingConfig) {
        super(documentStructure, indexWriterFactory, dirFactory, dirFile, failureStorage, indexId);
        this.queueThreshold = queueThreshold;
        this.sampler = new NonUniqueIndexSampler(samplingConfig.bufferSize());
    }

    public void add(long nodeId, Object propertyValue) throws IOException, IndexCapacityExceededException {
        Fieldable encodedValue = this.documentStructure.encodeAsFieldable(propertyValue);
        this.sampler.include(encodedValue.stringValue());
        this.writer.addDocument(this.documentStructure.newDocumentRepresentingProperty(nodeId, encodedValue));
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
        return new IndexUpdater(){

            public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException {
                return Reservation.EMPTY;
            }

            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                switch (update.getUpdateMode()) {
                    case ADDED: {
                        Fieldable encodedValue = NonUniqueLuceneIndexPopulator.this.documentStructure.encodeAsFieldable(update.getValueAfter());
                        NonUniqueLuceneIndexPopulator.this.sampler.include(encodedValue.stringValue());
                        break;
                    }
                    case CHANGED: {
                        Fieldable encodedValueBefore = NonUniqueLuceneIndexPopulator.this.documentStructure.encodeAsFieldable(update.getValueBefore());
                        NonUniqueLuceneIndexPopulator.this.sampler.exclude(encodedValueBefore.stringValue());
                        Fieldable encodedValueAfter = NonUniqueLuceneIndexPopulator.this.documentStructure.encodeAsFieldable(update.getValueAfter());
                        NonUniqueLuceneIndexPopulator.this.sampler.include(encodedValueAfter.stringValue());
                        break;
                    }
                    case REMOVED: {
                        Fieldable removedValue = NonUniqueLuceneIndexPopulator.this.documentStructure.encodeAsFieldable(update.getValueBefore());
                        NonUniqueLuceneIndexPopulator.this.sampler.exclude(removedValue.stringValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown update mode " + update.getUpdateMode());
                    }
                }
                NonUniqueLuceneIndexPopulator.this.updates.add(update);
            }

            public void close() throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                if (NonUniqueLuceneIndexPopulator.this.updates.size() > NonUniqueLuceneIndexPopulator.this.queueThreshold) {
                    NonUniqueLuceneIndexPopulator.this.flush();
                    NonUniqueLuceneIndexPopulator.this.updates.clear();
                }
            }

            public void remove(PrimitiveLongSet nodeIds) throws IOException {
                throw new UnsupportedOperationException("Should not remove() from populating index.");
            }
        };
    }

    public long sampleResult(Register.DoubleLong.Out result) {
        return this.sampler.result(result);
    }

    @Override
    protected void flush() throws IOException, IndexCapacityExceededException {
        block4: for (NodePropertyUpdate update : this.updates) {
            long nodeId = update.getNodeId();
            switch (update.getUpdateMode()) {
                case ADDED: 
                case CHANGED: {
                    Fieldable encodedValue = this.documentStructure.encodeAsFieldable(update.getValueAfter());
                    this.writer.updateDocument(this.documentStructure.newTermForChangeOrRemove(nodeId), this.documentStructure.newDocumentRepresentingProperty(nodeId, encodedValue));
                    continue block4;
                }
                case REMOVED: {
                    this.writer.deleteDocuments(this.documentStructure.newTermForChangeOrRemove(nodeId));
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown update mode " + update.getUpdateMode());
        }
    }
}

