/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexReference;
import org.neo4j.index.impl.lucene.IndexReferenceFactory;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.IndexTypeCache;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.MultipleBackupDeletionPolicy;
import org.neo4j.index.impl.lucene.WritableIndexReference;

class WritableIndexReferenceFactory
extends IndexReferenceFactory {
    WritableIndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        super(filesystemFacade, baseStorePath, typeCache);
    }

    @Override
    IndexReference createIndexReference(IndexIdentifier identifier) throws IOException {
        IndexWriter writer = this.newIndexWriter(identifier);
        IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)true);
        IndexSearcher indexSearcher = this.newIndexSearcher(identifier, reader);
        return new WritableIndexReference(identifier, indexSearcher, writer);
    }

    @Override
    IndexReference refresh(IndexReference indexReference) {
        try {
            IndexReader reader = indexReference.getSearcher().getIndexReader();
            IndexWriter writer = indexReference.getWriter();
            IndexReader reopened = IndexReader.openIfChanged((IndexReader)reader, (IndexWriter)writer, (boolean)true);
            if (reopened != null) {
                IndexSearcher newSearcher = this.newIndexSearcher(indexReference.getIdentifier(), reopened);
                indexReference.detachOrClose();
                return new WritableIndexReference(indexReference.getIdentifier(), newSearcher, writer);
            }
            return indexReference;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexWriter newIndexWriter(IndexIdentifier identifier) {
        try {
            Directory indexDirectory = this.getIndexDirectory(identifier);
            IndexType type = this.getType(identifier);
            IndexWriterConfig writerConfig = new IndexWriterConfig(LuceneDataSource.LUCENE_VERSION, type.analyzer);
            writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new MultipleBackupDeletionPolicy());
            Similarity similarity = type.getSimilarity();
            if (similarity != null) {
                writerConfig.setSimilarity(similarity);
            }
            return new IndexWriter(indexDirectory, writerConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

