/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessor;

public class LuceneAllDocumentsReader
implements BoundedIterable<Document> {
    private final IndexSearcher searcher;
    private final LuceneIndexAccessor.LuceneReferenceManager<IndexSearcher> searcherManager;

    public LuceneAllDocumentsReader(LuceneIndexAccessor.LuceneReferenceManager<IndexSearcher> searcherManager) {
        this.searcherManager = searcherManager;
        this.searcher = searcherManager.acquire();
    }

    public long maxCount() {
        return this.maxDocIdBoundary();
    }

    public Iterator<Document> iterator() {
        return new PrefetchingIterator<Document>(){
            private int docId;

            protected Document fetchNextOrNull() {
                Document document = null;
                while (document == null && LuceneAllDocumentsReader.this.isPossibleDocId(this.docId)) {
                    if (!LuceneAllDocumentsReader.this.deleted(this.docId)) {
                        document = LuceneAllDocumentsReader.this.getDocument(this.docId);
                    }
                    ++this.docId;
                }
                return document;
            }
        };
    }

    public void close() {
        try {
            this.searcherManager.release(this.searcher);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document getDocument(int docId) {
        try {
            return this.searcher.doc(docId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean deleted(int docId) {
        return this.searcher.getIndexReader().isDeleted(docId);
    }

    private boolean isPossibleDocId(int docId) {
        return docId < this.maxDocIdBoundary();
    }

    private int maxDocIdBoundary() {
        return this.searcher.maxDoc();
    }
}

