/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.lucene.document.Document;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public abstract class LuceneIndexPopulator<INDEX extends DatabaseIndex<?>>
implements IndexPopulator {
    protected final IndexUpdateIgnoreStrategy ignoreStrategy;
    protected INDEX luceneIndex;
    protected LuceneIndexWriter writer;

    protected LuceneIndexPopulator(INDEX luceneIndex, IndexUpdateIgnoreStrategy ignoreStrategy) {
        this.luceneIndex = luceneIndex;
        this.ignoreStrategy = ignoreStrategy;
    }

    public void create() {
        try {
            this.luceneIndex.create();
            this.luceneIndex.open();
            this.writer = this.luceneIndex.getIndexWriter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drop() {
        this.luceneIndex.drop();
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        return this.luceneIndex.snapshotFiles();
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
        assert (this.updatesForCorrectIndex(updates));
        try {
            this.writer.addDocuments(updates.size(), () -> updates.stream().map(u -> (ValueIndexEntryUpdate)u).filter(Predicate.not(arg_0 -> ((IndexUpdateIgnoreStrategy)this.ignoreStrategy).ignore(arg_0))).map(this::updateAsDocument).filter(Objects::nonNull).iterator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract Document updateAsDocument(ValueIndexEntryUpdate<?> var1);

    public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        try {
            if (populationCompletedSuccessfully) {
                this.luceneIndex.markAsOnline();
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.luceneIndex});
                throw throwable;
            }
        }
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.luceneIndex});
    }

    public void markAsFailed(String failure) {
        try {
            this.luceneIndex.markAsFailed(failure);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void includeSample(IndexEntryUpdate<?> update) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IndexSample sample(CursorContext cursorContext) {
        try {
            this.luceneIndex.maybeRefreshBlocking();
            try (Object reader = this.luceneIndex.getIndexReader(IndexUsageTracking.NO_USAGE_TRACKING);){
                IndexSample indexSample;
                block14: {
                    IndexSampler sampler = reader.createSampler();
                    try {
                        indexSample = sampler.sampleIndex(cursorContext, new AtomicBoolean());
                        if (sampler == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (sampler != null) {
                            try {
                                sampler.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    sampler.close();
                }
                return indexSample;
            }
        }
        catch (IOException | IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean updatesForCorrectIndex(Collection<? extends IndexEntryUpdate<?>> updates) {
        for (IndexEntryUpdate<?> update : updates) {
            if (update.indexKey().schema().equals((Object)this.luceneIndex.getDescriptor().schema())) continue;
            return false;
        }
        return true;
    }
}

