/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import org.apache.lucene.analysis.CharacterUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramDocumentStructure;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramTokenStream;

class TrigramQueryFactory {
    TrigramQueryFactory() {
    }

    static Query getById(long entityId) {
        Term term = TrigramDocumentStructure.newTermForChangeOrRemove(entityId);
        return new TermQuery(term);
    }

    static Query exact(String value) {
        return TrigramQueryFactory.trigramSearch(value);
    }

    static Query stringPrefix(String prefix) {
        return TrigramQueryFactory.trigramSearch(prefix);
    }

    static Query stringContains(String contains) {
        return TrigramQueryFactory.trigramSearch(contains);
    }

    static Query stringSuffix(String suffix) {
        return TrigramQueryFactory.trigramSearch(suffix);
    }

    static MatchAllDocsQuery allValues() {
        return new MatchAllDocsQuery();
    }

    static boolean needStoreFilter(PropertyIndexQuery predicate) {
        return !predicate.type().equals((Object)IndexQuery.IndexQueryType.ALL_ENTRIES);
    }

    private static Query trigramSearch(String searchString) {
        if (searchString.isEmpty()) {
            return TrigramQueryFactory.allValues();
        }
        TrigramTokenStream.CodePointBuffer codePointBuffer = TrigramTokenStream.getCodePoints(searchString);
        if (codePointBuffer.codePointCount() < 3) {
            String searchTerm = QueryParserBase.escape((String)searchString);
            Term term = new Term("0", "*" + searchTerm + "*");
            return new WildcardQuery(term);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (int i = 0; i < codePointBuffer.codePointCount() - 2 && i < IndexSearcher.getMaxClauseCount(); ++i) {
            String term = TrigramQueryFactory.getNgram(codePointBuffer, i, 3);
            ConstantScoreQuery termQuery = new ConstantScoreQuery((Query)new TermQuery(new Term("0", term)));
            builder.add((Query)termQuery, BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    private static String getNgram(TrigramTokenStream.CodePointBuffer codePointBuffer, int ngramIndex, int n) {
        char[] termCharBuffer = new char[2 * n];
        int length = CharacterUtils.toChars((int[])codePointBuffer.codePoints(), (int)ngramIndex, (int)n, (char[])termCharBuffer, (int)0);
        return new String(termCharBuffer, 0, length);
    }
}

