/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.neo4j.kernel.api.impl.schema.TextDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class TextIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;

    public TextIndexPopulatingUpdater(LuceneIndexWriter writer, IndexUpdateIgnoreStrategy ignoreStrategy) {
        this.writer = writer;
        this.ignoreStrategy = ignoreStrategy;
    }

    public void close() {
    }

    public void process(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        if (valueUpdate == null) {
            return;
        }
        try {
            long entityId = valueUpdate.getEntityId();
            Object[] values = valueUpdate.values();
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    this.writer.updateDocument(TextDocumentStructure.newTermForChangeOrRemove(entityId), TextDocumentStructure.documentRepresentingProperties(entityId, (Value[])values));
                    break;
                }
                case CHANGED: {
                    this.writer.updateOrDeleteDocument(TextDocumentStructure.newTermForChangeOrRemove(entityId), TextDocumentStructure.documentRepresentingProperties(entityId, (Value[])values));
                    break;
                }
                case REMOVED: {
                    this.writer.deleteDocuments(TextDocumentStructure.newTermForChangeOrRemove(entityId));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update mode " + String.valueOf(updateMode) + " for values " + Arrays.toString(values));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ValueIndexEntryUpdate asValueUpdate(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
        return !this.ignoreStrategy.ignore(valueUpdate) ? this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
    }
}

