/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.impl.index.OnThreadConcurrentMergeScheduler;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSettings;

public class IndexWriterConfigModes {

    public static interface Mode {
        public LogMergePolicy visitWithConfig(LogMergePolicy var1, Config var2);

        public IndexWriterConfig visitWithConfig(IndexWriterConfig var1, Config var2);
    }

    static class DefaultModes {
        DefaultModes() {
        }

        static abstract class Population
        implements Mode {
            Population() {
            }

            @Override
            public IndexWriterConfig visitWithConfig(IndexWriterConfig writerConfig, Config config) {
                writerConfig.setMaxBufferedDocs(((Integer)config.get(LuceneSettings.lucene_population_max_buffered_docs)).intValue());
                if (((Boolean)config.get(LuceneSettings.lucene_population_serial_merge_scheduler)).booleanValue()) {
                    writerConfig.setMergeScheduler((MergeScheduler)new OnThreadConcurrentMergeScheduler());
                }
                return writerConfig;
            }
        }

        static abstract class Standard
        implements Mode {
            Standard() {
            }

            @Override
            public IndexWriterConfig visitWithConfig(IndexWriterConfig writerConfig, Config config) {
                return writerConfig.setMaxBufferedDocs(((Integer)config.get(LuceneSettings.lucene_writer_max_buffered_docs)).intValue()).setRAMBufferSizeMB(((Double)config.get(LuceneSettings.lucene_standard_ram_buffer_size)).doubleValue());
            }
        }
    }

    private static abstract class TextBasedModes {
        public static final Mode STANDARD = new Standard();
        public static final Mode POPULATION = new Population();

        private TextBasedModes() {
        }

        private static class Standard
        extends DefaultModes.Standard {
            private Standard() {
            }

            @Override
            public LogMergePolicy visitWithConfig(LogMergePolicy mergePolicy, Config config) {
                mergePolicy.setMergeFactor(((Integer)config.get(LuceneSettings.lucene_merge_factor)).intValue());
                return mergePolicy;
            }
        }

        private static class Population
        extends DefaultModes.Population {
            private Population() {
            }

            @Override
            public LogMergePolicy visitWithConfig(LogMergePolicy mergePolicy, Config config) {
                mergePolicy.setMergeFactor(((Integer)config.get(LuceneSettings.lucene_merge_factor)).intValue());
                return mergePolicy;
            }

            @Override
            public IndexWriterConfig visitWithConfig(IndexWriterConfig writerConfig, Config config) {
                super.visitWithConfig(writerConfig, config).setRAMBufferSizeMB(((Double)config.get(LuceneSettings.lucene_population_ram_buffer_size)).doubleValue());
                return writerConfig;
            }
        }
    }

    public static final class VectorModes {
        public static final Mode STANDARD = new Standard();
        public static final Mode POPULATION = new Population();

        private static class Standard
        extends DefaultModes.Standard {
            private Standard() {
            }

            @Override
            public LogMergePolicy visitWithConfig(LogMergePolicy mergePolicy, Config config) {
                mergePolicy.setMergeFactor(((Integer)config.get(LuceneSettings.vector_standard_merge_factor)).intValue());
                return mergePolicy;
            }
        }

        private static class Population
        extends DefaultModes.Population {
            private Population() {
            }

            @Override
            public LogMergePolicy visitWithConfig(LogMergePolicy mergePolicy, Config config) {
                mergePolicy.setMergeFactor(((Integer)config.get(LuceneSettings.vector_population_merge_factor)).intValue());
                return mergePolicy;
            }

            @Override
            public IndexWriterConfig visitWithConfig(IndexWriterConfig writerConfig, Config config) {
                super.visitWithConfig(writerConfig, config).setRAMBufferSizeMB(((Double)config.get(LuceneSettings.vector_population_ram_buffer_size)).doubleValue());
                return writerConfig;
            }
        }
    }

    public static final class FulltextModes
    extends TextBasedModes {
        public static final Mode TRANSACTION_STATE = new TransactionState();

        private static class TransactionState
        extends TextBasedModes.Standard {
            private TransactionState() {
            }

            @Override
            public IndexWriterConfig visitWithConfig(IndexWriterConfig writerConfig, Config config) {
                return super.visitWithConfig(writerConfig, config).setCommitOnClose(false);
            }
        }
    }

    public static final class TextModes
    extends TextBasedModes {
    }
}

