/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.partition;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.backup.LuceneIndexSnapshots;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.Neo4jSearcherFactory;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class ReadOnlyIndexPartition
extends AbstractIndexPartition {
    private final SearcherManager searcherManager;
    private final DirectoryReader directoryReader;

    ReadOnlyIndexPartition(Path partitionFolder, Directory directory) throws IOException {
        super(partitionFolder, directory);
        this.directoryReader = DirectoryReader.open((Directory)directory);
        this.searcherManager = new SearcherManager(this.directoryReader, (SearcherFactory)new Neo4jSearcherFactory());
    }

    @Override
    public IndexWriter getIndexWriter() {
        throw new UnsupportedOperationException("Retrieving index writer from read only index partition is unsupported.");
    }

    @Override
    public PartitionSearcher acquireSearcher() throws IOException {
        return new PartitionSearcher((ReferenceManager<IndexSearcher>)this.searcherManager);
    }

    @Override
    public void maybeRefreshBlocking() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.searcherManager, this.directoryReader, this.directory});
    }

    @Override
    public ResourceIterator<Path> snapshot() throws IOException {
        return LuceneIndexSnapshots.forIndex(this.partitionFolder, this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accessClosedDirectory(ThrowingBiConsumer<Integer, Directory, IOException> visitor) throws IOException {
        int numDocs;
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            numDocs = searcher.getIndexReader().numDocs();
        }
        finally {
            this.searcherManager.close();
        }
        visitor.accept((Object)numDocs, (Object)this.directory);
    }
}

