/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.values.storable.Value;

public enum ValueEncoding {
    String{

        @Override
        public String key() {
            return "string";
        }

        @Override
        boolean canEncode(Value value) {
            return true;
        }

        @Override
        Field encodeField(String name, Value value) {
            return ValueEncoding.stringField(name, value.asObject().toString());
        }

        @Override
        void setFieldValue(Value value, Field field) {
            field.setStringValue(value.asObject().toString());
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(propertyNumber), value.asObject().toString())));
        }
    };

    private static final ValueEncoding[] AllEncodings;

    public abstract String key();

    public String key(int propertyNumber) {
        if (propertyNumber == 0) {
            return this.key();
        }
        return propertyNumber + this.key();
    }

    static int fieldPropertyNumber(String fieldName) {
        int index = 0;
        for (int i = 0; i < fieldName.length() && Character.isDigit(fieldName.charAt(i)); ++i) {
            ++index;
        }
        return index == 0 ? 0 : Integer.parseInt(fieldName.substring(0, index));
    }

    abstract boolean canEncode(Value var1);

    abstract Field encodeField(String var1, Value var2);

    abstract void setFieldValue(Value var1, Field var2);

    abstract Query encodeQuery(Value var1, int var2);

    public static ValueEncoding forValue(Value value) {
        for (ValueEncoding encoding : AllEncodings) {
            if (!encoding.canEncode(value)) continue;
            return encoding;
        }
        throw new IllegalStateException("Unable to encode the value " + java.lang.String.valueOf(value));
    }

    private static Field stringField(String identifier, String value) {
        return new StringField(identifier, value, Field.Store.NO);
    }

    static {
        AllEncodings = ValueEncoding.values();
    }
}

