/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.lucene.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LucenePartitionedSearch;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.values.storable.Value;

public interface LuceneIndexSearcher
extends Closeable {
    public static int getMaxClauseCount() {
        return IndexSearcher.getMaxClauseCount();
    }

    public LuceneDocument doc(int var1) throws IOException;

    public IndexProgressor searchDocValues(LuceneQueryContext var1, String var2, EntityConsumer var3) throws IOException;

    public IndexProgressor searchDocValues(LuceneQueryContext var1, String var2, IndexProgressor.EntityValueClient var3) throws IOException;

    public ValuesIterator searchVectors(LuceneQueryContext var1, IndexQueryConstraints var2) throws IOException;

    public List<LuceneDocument> searchTopN(LuceneQueryContext var1, int var2) throws IOException;

    public int count(LuceneQueryContext var1) throws IOException;

    public LuceneQueryContext rewrite(LuceneQueryContext var1) throws IOException;

    public LuceneQueryContext newQueryContext();

    public LucenePartitionedSearch newPartitionedSearcher(int var1);

    public LuceneAllDocumentsReader newAllDocumentsReader();

    public int numDocs();

    public IndexSampler newIndexSampler(TaskCoordinator var1, IndexSamplingConfig var2);

    public static final class InRangeEntityConsumer
    implements EntityConsumer {
        private final long fromIdInclusive;
        private final long toIdExclusive;
        private long reference;

        public InRangeEntityConsumer(long fromIdInclusive, long toIdExclusive) {
            this.fromIdInclusive = fromIdInclusive;
            this.toIdExclusive = toIdExclusive;
        }

        public long reference() {
            return this.reference;
        }

        @Override
        public boolean acceptEntity(long reference, float score, Value ... values) {
            if (this.fromIdInclusive <= reference && reference < this.toIdExclusive) {
                this.reference = reference;
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface EntityConsumer {
        public boolean acceptEntity(long var1, float var3, Value ... var4);
    }
}

