/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class LuceneFulltextDocumentStructure {
    public static final String FIELD_ENTITY_ID = "__neo4j__lucene__fulltext__index__internal__id__";

    private LuceneFulltextDocumentStructure() {
    }

    public static LuceneDocument documentRepresentingProperties(long id, String[] propertyNames, Value[] values) {
        return LuceneDocumentsFactory.CURRENT.reusableFulltextDocument(id, propertyNames, values);
    }

    static long getEntityId(LuceneDocument from) {
        return Long.parseLong(from.get(FIELD_ENTITY_ID));
    }

    static LuceneQueryContext newCountEntityEntriesQuery(LuceneIndexSearcher indexSearcher, long nodeId, String[] propertyKeys, Value ... propertyValues) {
        LuceneQueryContext queryContext = indexSearcher.newQueryContext();
        queryContext.addMustTerm(FIELD_ENTITY_ID, String.valueOf(nodeId));
        for (int i = 0; i < propertyKeys.length; ++i) {
            String propertyKey = propertyKeys[i];
            Value value = propertyValues[i];
            if (value.valueGroup() == ValueGroup.TEXT || value.valueGroup() == ValueGroup.TEXT_ARRAY) continue;
            queryContext.addMustNotHaveField(propertyKey);
        }
        return queryContext;
    }
}

