/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.Locale;
import java.util.OptionalInt;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfigValidationRecords;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfigUtils;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexSettingValidators {
    IndexSettingValidators() {
    }

    static final class QuantizationEnabledValidator
    extends IndexSettingValidator<BooleanValue, Boolean> {
        private final BooleanSet quantizationBooleans;

        QuantizationEnabledValidator(BooleanSet supportedQuantizationBooleans, boolean readDefaultQuantizationEnabled, boolean writeDefaultQuantizationEnabled) {
            super(IndexSetting.vector_Quantization_Enabled(), readDefaultQuantizationEnabled, writeDefaultQuantizationEnabled);
            this.quantizationBooleans = supportedQuantizationBooleans;
            assert (supportedQuantizationBooleans.containsAll(new boolean[]{readDefaultQuantizationEnabled, writeDefaultQuantizationEnabled}));
        }

        @Override
        Boolean map(BooleanValue value) {
            return value.booleanValue();
        }

        @Override
        Value map(Boolean value) {
            return Values.booleanValue((boolean)value);
        }

        @Override
        IndexConfigValidationRecords.IndexConfigValidationRecord validate(SettingsAccessor accessor) {
            IndexConfigValidationRecords.IndexConfigValidationRecord record = this.extractOrDefault(accessor);
            if (!(record instanceof IndexConfigValidationRecords.Pending)) {
                return record;
            }
            IndexConfigValidationRecords.Pending pending = (IndexConfigValidationRecords.Pending)record;
            AnyValue rawValue = pending.rawValue();
            if (rawValue == Values.NO_VALUE) {
                return new IndexConfigValidationRecords.InvalidValue(pending, null, (Object)this.quantizationBooleans);
            }
            if (!(rawValue instanceof BooleanValue)) {
                return new IndexConfigValidationRecords.IncorrectType(pending, BooleanValue.class);
            }
            BooleanValue booleanValue = (BooleanValue)rawValue;
            Boolean quantization = this.map(booleanValue);
            return quantization == null ? new IndexConfigValidationRecords.InvalidValue(pending, (Object)this.quantizationBooleans) : new IndexConfigValidationRecords.Valid(this.setting, (Object)quantization, this.map(quantization));
        }
    }

    static final class SimilarityFunctionValidator
    extends IndexSettingValidator<TextValue, VectorSimilarityFunction> {
        private final MapIterable<String, VectorSimilarityFunction> similarityFunctions;

        SimilarityFunctionValidator(MapIterable<String, VectorSimilarityFunction> supportedSimilarityFunctions) {
            this(supportedSimilarityFunctions, null);
        }

        SimilarityFunctionValidator(MapIterable<String, VectorSimilarityFunction> supportedSimilarityFunctions, VectorSimilarityFunction defaultSimilarityFunction) {
            super(IndexSetting.vector_Similarity_Function(), defaultSimilarityFunction);
            this.similarityFunctions = supportedSimilarityFunctions;
            assert (defaultSimilarityFunction == null || supportedSimilarityFunctions.containsValue((Object)defaultSimilarityFunction));
        }

        @Override
        VectorSimilarityFunction map(TextValue textValue) {
            return (VectorSimilarityFunction)this.similarityFunctions.get((Object)textValue.stringValue().toUpperCase(Locale.ROOT));
        }

        @Override
        Value map(VectorSimilarityFunction similarityFunction) {
            return Values.stringValue((String)similarityFunction.functionName());
        }

        @Override
        IndexConfigValidationRecords.IndexConfigValidationRecord validate(SettingsAccessor accessor) {
            IndexConfigValidationRecords.IndexConfigValidationRecord record = this.extractOrDefault(accessor);
            if (!(record instanceof IndexConfigValidationRecords.Pending)) {
                return record;
            }
            IndexConfigValidationRecords.Pending pending = (IndexConfigValidationRecords.Pending)record;
            AnyValue rawValue = pending.rawValue();
            if (rawValue == Values.NO_VALUE) {
                return new IndexConfigValidationRecords.InvalidValue(pending, null, (Object)this.similarityFunctions.keysView());
            }
            if (!(rawValue instanceof TextValue)) {
                return new IndexConfigValidationRecords.IncorrectType(pending, TextValue.class);
            }
            TextValue textValue = (TextValue)rawValue;
            VectorSimilarityFunction similarityFunction = this.map(textValue);
            return similarityFunction == null ? new IndexConfigValidationRecords.InvalidValue(pending, (Object)this.similarityFunctions.keysView()) : new IndexConfigValidationRecords.Valid(this.setting, (Object)similarityFunction, this.map(similarityFunction));
        }
    }

    static final class OptionalIntSettingValidator
    extends IndexSettingValidator<IntegralValue, OptionalInt> {
        private final VectorIndexConfigUtils.Range<Integer> supportedRange;

        OptionalIntSettingValidator(IndexSetting setting, VectorIndexConfigUtils.Range<Integer> supportedRange) {
            this(setting, supportedRange, null);
        }

        OptionalIntSettingValidator(IndexSetting setting, VectorIndexConfigUtils.Range<Integer> supportedRange, OptionalInt defaultValue) {
            super(setting, defaultValue);
            this.supportedRange = supportedRange;
            assert (defaultValue == null || defaultValue.isEmpty() || supportedRange.contains(defaultValue.getAsInt()));
        }

        @Override
        OptionalInt map(IntegralValue dimensions) {
            return OptionalInt.of((int)dimensions.longValue());
        }

        @Override
        Value map(OptionalInt dimensions) {
            return dimensions.isPresent() ? Values.intValue((int)dimensions.getAsInt()) : NoValue.NO_VALUE;
        }

        @Override
        IndexConfigValidationRecords.IndexConfigValidationRecord validate(SettingsAccessor accessor) {
            IndexConfigValidationRecords.IndexConfigValidationRecord record = this.extractOrDefault(accessor);
            if (!(record instanceof IndexConfigValidationRecords.Pending)) {
                return record;
            }
            IndexConfigValidationRecords.Pending pending = (IndexConfigValidationRecords.Pending)record;
            AnyValue rawValue = pending.rawValue();
            if (rawValue == Values.NO_VALUE) {
                return new IndexConfigValidationRecords.InvalidValue(pending, null, this.supportedRange);
            }
            if (!(rawValue instanceof IntegralValue)) {
                return new IndexConfigValidationRecords.IncorrectType(pending, IntegralValue.class);
            }
            IntegralValue integralValue = (IntegralValue)rawValue;
            OptionalInt dimensions = this.map(integralValue);
            return this.supportedRange.contains(dimensions.orElseThrow(() -> new IllegalStateException("'%s' should not be empty at this point.".formatted(this.setting)))) ? new IndexConfigValidationRecords.Valid(this.setting, (Object)dimensions, this.map(dimensions)) : new IndexConfigValidationRecords.InvalidValue(pending, (Object)dimensions, this.supportedRange);
        }
    }

    static final class IntegerValidator
    extends IndexSettingValidator<IntegralValue, Integer> {
        private final VectorIndexConfigUtils.Range<Integer> supportedRange;

        IntegerValidator(IndexSetting setting, VectorIndexConfigUtils.Range<Integer> supportedRange) {
            this(setting, null, supportedRange);
        }

        IntegerValidator(IndexSetting setting, Integer defaultValue, VectorIndexConfigUtils.Range<Integer> supportedRange) {
            super(setting, defaultValue);
            this.supportedRange = supportedRange;
            assert (defaultValue == null || supportedRange.contains(defaultValue));
        }

        @Override
        Integer map(IntegralValue value) {
            return (int)value.longValue();
        }

        @Override
        Value map(Integer value) {
            return Values.intValue((int)value);
        }

        @Override
        IndexConfigValidationRecords.IndexConfigValidationRecord validate(SettingsAccessor accessor) {
            IndexConfigValidationRecords.IndexConfigValidationRecord record = this.extractOrDefault(accessor);
            if (!(record instanceof IndexConfigValidationRecords.Pending)) {
                return record;
            }
            IndexConfigValidationRecords.Pending pending = (IndexConfigValidationRecords.Pending)record;
            AnyValue rawValue = pending.rawValue();
            if (rawValue == Values.NO_VALUE) {
                return new IndexConfigValidationRecords.InvalidValue(pending, null, this.supportedRange);
            }
            if (!(rawValue instanceof IntegralValue)) {
                return new IndexConfigValidationRecords.IncorrectType(pending, IntegralValue.class);
            }
            IntegralValue integralValue = (IntegralValue)rawValue;
            Integer value = this.map(integralValue);
            return this.supportedRange.contains(value) ? new IndexConfigValidationRecords.Valid(this.setting, (Object)value, this.map(value)) : new IndexConfigValidationRecords.InvalidValue(pending, (Object)value, this.supportedRange);
        }
    }

    static class ReadDefaultOnly<TYPE>
    extends IndexSettingValidator<NoValue, TYPE> {
        protected ReadDefaultOnly(IndexSetting setting, TYPE readDefault) {
            super(setting, readDefault, null);
        }

        @Override
        TYPE map(NoValue value) {
            return (TYPE)this.readDefault;
        }

        @Override
        NoValue map(TYPE value) {
            return NoValue.NO_VALUE;
        }

        @Override
        IndexConfigValidationRecords.IndexConfigValidationRecord validate(SettingsAccessor accessor) {
            if (accessor.containsSetting(this.setting)) {
                return new IndexConfigValidationRecords.UnrecognizedSetting(this.setting.getSettingName());
            }
            return new IndexConfigValidationRecords.Valid(this.setting, this.readDefault, (Value)this.map((TYPE)this.readDefault));
        }
    }

    static abstract class IndexSettingValidator<VALUE extends Value, TYPE> {
        protected final IndexSetting setting;
        protected final TYPE createDefault;
        protected final TYPE readDefault;

        protected IndexSettingValidator(IndexSetting setting) {
            this(setting, null);
        }

        protected IndexSettingValidator(IndexSetting setting, TYPE defaultValue) {
            this(setting, defaultValue, defaultValue);
        }

        protected IndexSettingValidator(IndexSetting setting, TYPE readDefault, TYPE createDefault) {
            this.setting = setting;
            this.readDefault = readDefault;
            this.createDefault = createDefault;
        }

        abstract TYPE map(VALUE var1);

        abstract Value map(TYPE var1);

        abstract IndexConfigValidationRecords.IndexConfigValidationRecord validate(SettingsAccessor var1);

        protected IndexConfigValidationRecords.IndexConfigValidationRecord extractOrDefault(SettingsAccessor accessor) {
            if (accessor.containsSetting(this.setting)) {
                return new IndexConfigValidationRecords.Pending(this.setting, accessor.get(this.setting));
            }
            if (this.createDefault == null) {
                return new IndexConfigValidationRecords.MissingSetting(this.setting);
            }
            return new IndexConfigValidationRecords.Valid(this.setting, this.createDefault, this.map(this.createDefault));
        }

        protected IndexConfigValidationRecords.Valid trustIsValid(SettingsAccessor accessor) {
            TYPE value = accessor.containsSetting(this.setting) ? this.map((VALUE)((Value)accessor.get(this.setting))) : this.readDefault;
            return new IndexConfigValidationRecords.Valid(this.setting, value, this.map(value));
        }

        protected IndexSetting setting() {
            return this.setting;
        }
    }
}

