/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;

public interface LuceneDirectory
extends Closeable {
    public String[] listAll() throws IOException;

    public void deleteFile(String var1) throws IOException;

    public boolean indexExists() throws IOException;

    public LuceneDirectoryReader open() throws IOException;

    public boolean checkIndexIsClean() throws IOException;

    public boolean validVersion() throws IOException;

    public boolean hasCommits() throws IOException;

    public Collection<String> latestCommitFileNames() throws IOException;

    public LuceneIndexWriter newWriter(LuceneIndexWriterConfig var1) throws IOException;

    public static class DelegatingLuceneDirectory
    implements LuceneDirectory {
        private final LuceneDirectory delegate;

        public DelegatingLuceneDirectory(LuceneDirectory delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public String[] listAll() throws IOException {
            return this.delegate.listAll();
        }

        @Override
        public void deleteFile(String name) throws IOException {
            this.delegate.deleteFile(name);
        }

        @Override
        public boolean indexExists() throws IOException {
            return this.delegate.indexExists();
        }

        @Override
        public LuceneDirectoryReader open() throws IOException {
            return this.delegate.open();
        }

        @Override
        public boolean checkIndexIsClean() throws IOException {
            return this.delegate.checkIndexIsClean();
        }

        @Override
        public boolean validVersion() throws IOException {
            return this.delegate.validVersion();
        }

        @Override
        public boolean hasCommits() throws IOException {
            return this.delegate.hasCommits();
        }

        @Override
        public Collection<String> latestCommitFileNames() throws IOException {
            return this.delegate.latestCommitFileNames();
        }

        @Override
        public LuceneIndexWriter newWriter(LuceneIndexWriterConfig writerConfig) throws IOException {
            return this.delegate.newWriter(writerConfig);
        }
    }
}

