/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.DocIdSetBuilder;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.util.VisibleForTesting;

class Lucene9DocValuesCollector
extends SimpleCollector {
    private LeafReaderContext context;
    private int segmentHits;
    private int totalHits;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private Docs docs;

    Lucene9DocValuesCollector() {
    }

    public IndexProgressor getIndexProgressor(String field, IndexProgressor.EntityValueClient client) {
        return new LongValuesIndexProgressor(this.getMatchingDocs(), this.getTotalHits(), field, (arg_0, arg_1, arg_2) -> ((IndexProgressor.EntityValueClient)client).acceptEntity(arg_0, arg_1, arg_2));
    }

    public IndexProgressor getIndexProgressor(String field, LuceneIndexSearcher.EntityConsumer entityConsumer) {
        return new LongValuesIndexProgressor(this.getMatchingDocs(), this.getTotalHits(), field, entityConsumer);
    }

    int getTotalHits() {
        return this.totalHits;
    }

    public final void collect(int doc) throws IOException {
        this.docs.addDoc(doc);
        ++this.segmentHits;
        ++this.totalHits;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.docs != null && this.segmentHits > 0) {
            this.createMatchingDocs();
        }
        int maxDoc = context.reader().maxDoc();
        this.docs = new Docs(maxDoc);
        this.segmentHits = 0;
        this.context = context;
    }

    @VisibleForTesting
    List<MatchingDocs> getMatchingDocs() {
        if (this.docs != null && this.segmentHits > 0) {
            try {
                this.createMatchingDocs();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.docs = null;
                this.context = null;
            }
        }
        return this.matchingDocs;
    }

    private void createMatchingDocs() throws IOException {
        this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits));
    }

    private static class LongValuesIndexProgressor
    extends LongValuesSource
    implements IndexProgressor {
        private final LuceneIndexSearcher.EntityConsumer entityConsumer;

        LongValuesIndexProgressor(Iterable<MatchingDocs> allMatchingDocs, int totalHits, String field, LuceneIndexSearcher.EntityConsumer entityConsumer) {
            super(allMatchingDocs, totalHits, field);
            this.entityConsumer = entityConsumer;
        }

        public boolean next() {
            while (this.fetchNextEntityId()) {
                if (!this.entityConsumer.acceptEntity(this.next, this.score, null)) continue;
                return true;
            }
            return false;
        }

        public void close() {
        }
    }

    private static final class Docs {
        private final DocIdSetBuilder bits;

        Docs(int maxDoc) {
            this.bits = new DocIdSetBuilder(maxDoc);
        }

        private void addDoc(int docId) {
            this.bits.grow(1).add(docId);
        }

        private DocIdSetIterator getDocIdSet() throws IOException {
            return this.bits.build().iterator();
        }
    }

    static final class MatchingDocs {
        public final LeafReaderContext context;
        final DocIdSetIterator docIdSet;
        final int totalHits;

        MatchingDocs(LeafReaderContext context, DocIdSetIterator docIdSet, int totalHits) {
            this.context = context;
            this.docIdSet = docIdSet;
            this.totalHits = totalHits;
        }

        private NumericDocValues readDocValues(String field) {
            try {
                NumericDocValues dv = this.context.reader().getNumericDocValues(field);
                if (dv == null) {
                    FieldInfo fi = this.context.reader().getFieldInfos().fieldInfo(field);
                    DocValuesType actual = null;
                    if (fi != null) {
                        actual = fi.getDocValuesType();
                    }
                    throw new IllegalStateException("The field '" + field + "' is not indexed properly, expected NumericDV, but got '" + String.valueOf(actual) + "'");
                }
                return dv;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class LongValuesSource {
        private final Iterator<MatchingDocs> matchingDocs;
        private final String field;
        final int totalHits;
        DocIdSetIterator currentIdIterator;
        NumericDocValues currentDocValues;
        MatchingDocs currentDocs;
        float score;
        int index;
        long next;

        LongValuesSource(Iterable<MatchingDocs> allMatchingDocs, int totalHits, String field) {
            this.totalHits = totalHits;
            this.field = field;
            this.matchingDocs = allMatchingDocs.iterator();
            this.score = Float.NaN;
        }

        boolean ensureValidDisi() {
            while (this.currentIdIterator == null) {
                if (this.matchingDocs.hasNext()) {
                    this.currentDocs = this.matchingDocs.next();
                    this.currentIdIterator = this.currentDocs.docIdSet;
                    this.index = 0;
                    if (this.currentIdIterator == null) continue;
                    this.currentDocValues = this.currentDocs.readDocValues(this.field);
                    continue;
                }
                return false;
            }
            return true;
        }

        boolean fetchNextEntityId() {
            try {
                if (this.ensureValidDisi()) {
                    int nextDoc = this.currentIdIterator.nextDoc();
                    if (nextDoc != Integer.MAX_VALUE) {
                        ++this.index;
                        int valueDoc = this.currentDocValues.advance(nextDoc);
                        if (valueDoc != nextDoc) {
                            throw new RuntimeException("Document id and document value iterators are out of sync. Id iterator gave me document " + nextDoc + ", while the value iterator gave me document " + valueDoc + ".");
                        }
                        this.next = this.currentDocValues.longValue();
                        return true;
                    }
                    this.currentIdIterator = null;
                    return this.fetchNextEntityId();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
    }
}

