/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.TextDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;

public abstract class LuceneQueryFactory {
    protected LuceneQueryFactory() {
    }

    public abstract LuceneQueryContext createQuery(LuceneIndexSearcher var1, PropertyIndexQuery var2, IndexQueryConstraints var3, IndexDescriptor var4);

    protected IllegalArgumentException invalidQuery(IndexDescriptor descriptor, PropertyIndexQuery predicate) {
        return new IllegalArgumentException("Index query not supported for %s index. Query: %s".formatted(descriptor.getIndexType(), predicate));
    }

    public static class VectorQueryFactory
    extends LuceneQueryFactory {
        private final VectorDocumentStructure documentStructure;

        public VectorQueryFactory(VectorDocumentStructure documentStructure) {
            this.documentStructure = documentStructure;
        }

        @Override
        public LuceneQueryContext createQuery(LuceneIndexSearcher searcher, PropertyIndexQuery predicate, IndexQueryConstraints constraints, IndexDescriptor descriptor) {
            return switch (predicate.type()) {
                case IndexQuery.IndexQueryType.ALL_ENTRIES -> searcher.newQueryContext().matchAll();
                case IndexQuery.IndexQueryType.NEAREST_NEIGHBORS -> {
                    PropertyIndexQuery.NearestNeighborsPredicate nearestNeighborsPredicate = (PropertyIndexQuery.NearestNeighborsPredicate)predicate;
                    long k = Math.min((long)nearestNeighborsPredicate.numberOfNeighbors(), constraints.limit().orElse(Integer.MAX_VALUE));
                    long effectiveK = k + constraints.skip().orElse(0L);
                    yield searcher.newQueryContext().approximateNearestNeighbors(this.documentStructure, nearestNeighborsPredicate.query(), Math.toIntExact(effectiveK));
                }
                default -> throw this.invalidQuery(descriptor, predicate);
            };
        }
    }

    public static class TrigramQueryFactory
    extends LuceneQueryFactory {
        public static final LuceneQueryFactory INSTANCE = new TrigramQueryFactory();

        private TrigramQueryFactory() {
        }

        @Override
        public LuceneQueryContext createQuery(LuceneIndexSearcher searcher, PropertyIndexQuery predicate, IndexQueryConstraints constraints, IndexDescriptor descriptor) {
            return switch (predicate.type()) {
                case IndexQuery.IndexQueryType.ALL_ENTRIES -> searcher.newQueryContext().matchAll();
                case IndexQuery.IndexQueryType.EXACT -> {
                    String value = ((PropertyIndexQuery.ExactPredicate)predicate).value().asObject().toString();
                    yield searcher.newQueryContext().trigramSearch(value);
                }
                case IndexQuery.IndexQueryType.STRING_PREFIX -> {
                    PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                    yield searcher.newQueryContext().trigramSearch(spp.prefix().stringValue());
                }
                case IndexQuery.IndexQueryType.STRING_CONTAINS -> {
                    PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                    yield searcher.newQueryContext().trigramSearch(scp.contains().stringValue());
                }
                case IndexQuery.IndexQueryType.STRING_SUFFIX -> {
                    PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                    yield searcher.newQueryContext().trigramSearch(ssp.suffix().stringValue());
                }
                default -> throw this.invalidQuery(descriptor, predicate);
            };
        }
    }

    public static class TextQueryFactory
    extends LuceneQueryFactory {
        public static final LuceneQueryFactory INSTANCE = new TextQueryFactory();

        private TextQueryFactory() {
        }

        @Override
        public LuceneQueryContext createQuery(LuceneIndexSearcher searcher, PropertyIndexQuery predicate, IndexQueryConstraints constraints, IndexDescriptor descriptor) {
            return switch (predicate.type()) {
                case IndexQuery.IndexQueryType.ALL_ENTRIES -> searcher.newQueryContext().matchAll();
                case IndexQuery.IndexQueryType.EXACT -> TextDocumentStructure.newSeekQuery(searcher, ((PropertyIndexQuery.ExactPredicate)predicate).value());
                case IndexQuery.IndexQueryType.STRING_PREFIX -> {
                    PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                    yield searcher.newQueryContext().stringPrefix(spp.prefix().stringValue());
                }
                case IndexQuery.IndexQueryType.STRING_CONTAINS -> {
                    PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                    yield searcher.newQueryContext().stringContains(scp.contains().stringValue());
                }
                case IndexQuery.IndexQueryType.STRING_SUFFIX -> {
                    PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                    yield searcher.newQueryContext().stringSuffix(ssp.suffix().stringValue());
                }
                default -> throw this.invalidQuery(descriptor, predicate);
            };
        }
    }
}

