/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.TextIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public class TextIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<ValueIndexReader>> {
    public TextIndexPopulator(DatabaseIndex<ValueIndexReader> luceneIndex, IndexUpdateIgnoreStrategy ignoreStrategy) {
        super(luceneIndex, ignoreStrategy);
    }

    @Override
    protected LuceneDocument updateAsDocument(ValueIndexEntryUpdate update) {
        return LuceneDocumentsFactory.CURRENT.reusableTextDocument(update.getEntityId(), update.values());
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        return new TextIndexPopulatingUpdater(this.writer, this.ignoreStrategy);
    }
}

