/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexReader;
import org.neo4j.kernel.api.impl.schema.LuceneQueryFactory;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.storable.Value;

public class TextIndexReader
extends AbstractTextIndexReader {
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public TextIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator, IndexUsageTracking usageTracker, LogProvider logProvider) {
        super(descriptor, searcherReference, usageTracker, LuceneQueryFactory.TextQueryFactory.INSTANCE, logProvider);
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        return this.getIndexSearcher().newIndexSampler(this.taskCoordinator, this.samplingConfig);
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return false;
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        LuceneIndexSearcher luceneIndexSearcher = this.getIndexSearcher();
        LuceneQueryContext queryContext = luceneIndexSearcher.newQueryContext();
        queryContext.addMustTerm("id", String.valueOf(entityId));
        queryContext.addMustSeek(propertyValues);
        try {
            return luceneIndexSearcher.count(queryContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

