/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VectorCandidate;

class VectorIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<VectorIndexReader>> {
    private final VectorDocumentStructure documentStructure;
    private final Neo4jVectorSimilarityFunction similarityFunction;

    VectorIndexPopulator(DatabaseIndex<VectorIndexReader> luceneIndex, IndexUpdateIgnoreStrategy ignoreStrategy, VectorDocumentStructure documentStructure, Neo4jVectorSimilarityFunction similarityFunction) {
        super(luceneIndex, ignoreStrategy);
        this.documentStructure = documentStructure;
        this.similarityFunction = similarityFunction;
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        return new VectorIndexPopulatingUpdater(this.writer, this.ignoreStrategy, this.documentStructure, this.similarityFunction);
    }

    @Override
    protected LuceneDocument updateAsDocument(ValueIndexEntryUpdate update) {
        long entityId = update.getEntityId();
        VectorCandidate candidate = VectorCandidate.maybeFrom((AnyValue)update.values()[0]);
        return LuceneDocumentsFactory.CURRENT.createVectorDocument(this.documentStructure, entityId, candidate, this.similarityFunction);
    }
}

