/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.ScoredEntityIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexReader;
import org.neo4j.kernel.api.impl.schema.LuceneQueryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneScoredEntityIndexProgressor;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.storable.Value;

class VectorIndexReader
extends AbstractLuceneIndexReader {
    private final OptionalInt dimensions;
    private final List<SearcherReference> searchers;

    VectorIndexReader(IndexDescriptor descriptor, VectorIndexConfig vectorIndexConfig, VectorDocumentStructure documentStructure, List<SearcherReference> searchers, IndexUsageTracking usageTracker, LogProvider logProvider) {
        super(descriptor, usageTracker, new LuceneQueryFactory.VectorQueryFactory(documentStructure), logProvider);
        this.dimensions = vectorIndexConfig.dimensions();
        this.searchers = searchers;
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        if (this.searchers.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        LuceneQueryContext queryContext = this.searchers.getFirst().getIndexSearcher().newQueryContext().exactTerm("id", entityId);
        for (SearcherReference searcher : this.searchers) {
            try {
                count += (long)searcher.getIndexSearcher().count(queryContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return count;
    }

    public IndexSampler createSampler() {
        return IndexSampler.EMPTY;
    }

    @Override
    public void query(IndexProgressor.EntityValueClient client, QueryContext queryContext, CursorContext cursorContext, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        super.query(client, queryContext, cursorContext, this.adjustedConstraints(constraints, predicates), predicates);
    }

    @Override
    public PropertyIndexQuery validateSingleQuery(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        PropertyIndexQuery predicate = super.validateSingleQuery(constraints, predicates);
        if (predicate instanceof PropertyIndexQuery.NearestNeighborsPredicate) {
            PropertyIndexQuery.NearestNeighborsPredicate nearestNeighbour = (PropertyIndexQuery.NearestNeighborsPredicate)predicate;
            float[] queryVector = nearestNeighbour.query();
            if (this.dimensions.isPresent() && queryVector.length != this.dimensions.getAsInt()) {
                throw IndexNotApplicableKernelException.vectorIndexDimensionalityMismatch((String)this.indexName(), (int)queryVector.length, (int)this.dimensions.getAsInt());
            }
        }
        return predicate;
    }

    private IndexQueryConstraints adjustedConstraints(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexQueryConstraints indexQueryConstraints;
        PropertyIndexQuery propertyIndexQuery = this.validateSingleQuery(constraints, predicates);
        if (propertyIndexQuery instanceof PropertyIndexQuery.NearestNeighborsPredicate) {
            PropertyIndexQuery.NearestNeighborsPredicate nearestNeighbour = (PropertyIndexQuery.NearestNeighborsPredicate)propertyIndexQuery;
            indexQueryConstraints = constraints.limit(Math.min((long)nearestNeighbour.numberOfNeighbors(), constraints.limit().orElse(Integer.MAX_VALUE)));
        } else {
            indexQueryConstraints = constraints;
        }
        return indexQueryConstraints;
    }

    @Override
    protected IndexProgressor indexProgressor(LuceneQueryFactory queryFactory, PropertyIndexQuery predicate, IndexQueryConstraints constraints, IndexProgressor.EntityValueClient client) {
        ValuesIterator iterator = this.searchers.isEmpty() ? ValuesIterator.EMPTY : this.searchLucene(queryFactory.createQuery(this.searchers.getFirst().getIndexSearcher(), predicate, constraints, this.descriptor), constraints);
        return new LuceneScoredEntityIndexProgressor(iterator, client, constraints);
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return false;
    }

    @Override
    public void close() {
        IOUtils.AutoCloseables closeables;
        try (IOUtils.AutoCloseables autoCloseables = closeables = new IOUtils.AutoCloseables(IndexReaderCloseException::new, this.searchers);){
            super.close();
        }
    }

    private ValuesIterator searchLucene(LuceneQueryContext queryContext, IndexQueryConstraints constraints) {
        try {
            ArrayList<ValuesIterator> results = new ArrayList<ValuesIterator>(this.searchers.size());
            for (SearcherReference searcher : this.searchers) {
                ValuesIterator valuesIterator = searcher.getIndexSearcher().searchVectors(queryContext, constraints);
                results.add(valuesIterator);
            }
            return ScoredEntityIterator.mergeIterators(results);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive) throws IOException {
        if (this.searchers.isEmpty()) {
            return BoundedIterable.empty();
        }
        String field = "id";
        LuceneQueryContext queryContext = this.searchers.getFirst().getIndexSearcher().newQueryContext().matchAll();
        ArrayList<BoundedIterable<Long>> iterables = new ArrayList<BoundedIterable<Long>>(this.searchers.size());
        for (SearcherReference searcher : this.searchers) {
            iterables.add(this.newAllEntriesValueReaderForPartition(field, searcher.getIndexSearcher(), queryContext, fromIdInclusive, toIdExclusive));
        }
        return BoundedIterable.concat(iterables);
    }
}

