/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.builder;

import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.builder.LuceneIndexStorageBuilder;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLuceneIndexBuilder<T extends AbstractLuceneIndexBuilder<T>> {
    protected LuceneIndexStorageBuilder storageBuilder = LuceneIndexStorageBuilder.create();
    protected final DatabaseReadOnlyChecker readOnlyChecker;
    protected boolean permanentlyReadOnly;
    protected final LogProvider logProvider;

    public AbstractLuceneIndexBuilder(DatabaseReadOnlyChecker readOnlyChecker, LogProvider logProvider) {
        this.readOnlyChecker = Objects.requireNonNull(readOnlyChecker);
        this.logProvider = logProvider;
    }

    public T withIndexStorage(PartitionedIndexStorage indexStorage) {
        this.storageBuilder.withIndexStorage(indexStorage);
        return (T)this;
    }

    public T withDirectoryFactory(DirectoryFactory directoryFactory) {
        this.storageBuilder.withDirectoryFactory(directoryFactory);
        return (T)this;
    }

    public T withLuceneContext(LuceneContext luceneContext) {
        this.storageBuilder.withLuceneContext(luceneContext);
        return (T)this;
    }

    public T withFileSystem(FileSystemAbstraction fileSystem) {
        this.storageBuilder.withFileSystem(fileSystem);
        return (T)this;
    }

    public T withIndexRootFolder(Path indexRootFolder) {
        this.storageBuilder.withIndexFolder(indexRootFolder);
        return (T)this;
    }

    public T permanentlyReadOnly() {
        this.permanentlyReadOnly = true;
        return (T)this;
    }
}

