/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.builder;

import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;

public class LuceneIndexStorageBuilder {
    private DirectoryFactory directoryFactory;
    private FileSystemAbstraction fileSystem;
    private Path indexRootFolder;
    private PartitionedIndexStorage indexStorage;
    private LuceneContext luceneContext;

    private LuceneIndexStorageBuilder() {
    }

    public static LuceneIndexStorageBuilder create() {
        return new LuceneIndexStorageBuilder();
    }

    public PartitionedIndexStorage build() {
        if (this.indexStorage == null) {
            Objects.requireNonNull(this.luceneContext);
            if (this.directoryFactory == null) {
                this.directoryFactory = DirectoryFactory.persistent(this.luceneContext);
            }
            Objects.requireNonNull(this.fileSystem);
            Objects.requireNonNull(this.indexRootFolder);
            this.indexStorage = new PartitionedIndexStorage(this.luceneContext, this.directoryFactory, this.fileSystem, this.indexRootFolder);
        }
        return this.indexStorage;
    }

    public LuceneIndexStorageBuilder withDirectoryFactory(DirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
        return this;
    }

    public LuceneIndexStorageBuilder withLuceneContext(LuceneContext luceneContext) {
        this.luceneContext = luceneContext;
        return this;
    }

    public LuceneIndexStorageBuilder withFileSystem(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public LuceneIndexStorageBuilder withIndexFolder(Path indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
        return this;
    }

    public LuceneIndexStorageBuilder withIndexStorage(PartitionedIndexStorage indexStorage) {
        this.indexStorage = indexStorage;
        return this;
    }
}

