/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSearcherManager;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9IndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Neo4jIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9SearcherManager;

public class Lucene9DirectoryReader
implements LuceneDirectoryReader {
    private final DirectoryReader reader;
    private static final SearcherFactory SEARCHER_FACTORY = new SearcherFactory(){

        public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) {
            return new Lucene9Neo4jIndexSearcher(reader);
        }
    };

    public Lucene9DirectoryReader(DirectoryReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean isOnline() throws IOException {
        return "online".equals(this.reader.getIndexCommit().getUserData().get("status"));
    }

    @Override
    public LuceneSearcherManager newSearcherManager() throws IOException {
        SearcherManager searcherManager = new SearcherManager(this.reader, SEARCHER_FACTORY);
        return new Lucene9SearcherManager(searcherManager);
    }

    @Override
    public LuceneIndexSearcher newDirectSearcher() {
        return new Lucene9IndexSearcher(new Lucene9Neo4jIndexSearcher((IndexReader)this.reader));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

