/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.index.backup.ReadOnlyIndexSnapshotFileIterator;
import org.neo4j.kernel.api.impl.index.backup.SnapshotReleaseException;
import org.neo4j.kernel.api.impl.index.backup.UnsupportedIndexDeletionPolicy;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Directory;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9DirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Document;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9DocumentsFactory;

class Lucene9IndexWriter
implements LuceneIndexWriter {
    private final IndexWriter indexWriter;

    Lucene9IndexWriter(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    @Override
    public LuceneDocument newDocument() {
        return new Lucene9Document();
    }

    @Override
    public void updateDocument(String idField, long id, LuceneDocument document) throws IOException {
        this.indexWriter.updateDocument(new Term(idField, Long.toString(id)), (Iterable)Lucene9IndexWriter.toInternalDocument(document));
    }

    @Override
    public void rollback() throws IOException {
        this.indexWriter.rollback();
    }

    @Override
    public LuceneDirectoryReader directoryReader() throws IOException {
        DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)this.indexWriter, (boolean)true, (boolean)false);
        return new Lucene9DirectoryReader(directoryReader);
    }

    @Override
    public void commit() throws IOException {
        this.indexWriter.commit();
    }

    @Override
    public boolean hasCommits() throws IOException {
        Directory directory = this.indexWriter.getDirectory();
        return DirectoryReader.indexExists((Directory)directory) && SegmentInfos.readLatestCommit((Directory)directory) != null;
    }

    @Override
    public void forceMerge(int maxNumSegments) throws IOException {
        this.indexWriter.forceMerge(maxNumSegments);
    }

    @Override
    public void markAsOnline() {
        this.indexWriter.setLiveCommitData((Iterable)ONLINE_COMMIT_USER_DATA);
    }

    @Override
    public void addDocuments(Iterable<LuceneDocument> documents) throws IOException {
        this.indexWriter.addDocuments(Lucene9IndexWriter.convertDocuments(documents));
    }

    @Override
    public int getMaxDocs() {
        return this.indexWriter.getDocStats().maxDoc;
    }

    @Override
    public void deleteDocuments(String idField, long id) throws IOException {
        this.indexWriter.deleteDocuments(new Term[]{new Term(idField, Long.toString(id))});
    }

    @Override
    public void addIndexes(LuceneDirectory directory) throws IOException {
        this.indexWriter.addIndexes(new Directory[]{((Lucene9Directory)directory).directory});
    }

    @Override
    public ResourceIterator<Path> snapshot(Path indexFolder) throws IOException {
        IndexDeletionPolicy deletionPolicy = this.indexWriter.getConfig().getIndexDeletionPolicy();
        if (deletionPolicy instanceof SnapshotDeletionPolicy) {
            SnapshotDeletionPolicy snapshotDeletionPolicy = (SnapshotDeletionPolicy)deletionPolicy;
            if (!this.hasCommits()) {
                return Iterators.emptyResourceIterator();
            }
            return new WritableIndexSnapshotFileIterator(indexFolder, snapshotDeletionPolicy);
        }
        throw new UnsupportedIndexDeletionPolicy("Can't perform index snapshot with specified index deletion policy: " + deletionPolicy.toString() + ". Only " + SnapshotDeletionPolicy.class.getName() + " is supported");
    }

    @Override
    public LuceneDocumentsFactory documentFactory() {
        return Lucene9DocumentsFactory.INSTANCE;
    }

    @Override
    public void addDocument(LuceneDocument document) throws IOException {
        this.indexWriter.addDocument((Iterable)Lucene9IndexWriter.toInternalDocument(document));
    }

    @Override
    public void close() throws IOException {
        this.indexWriter.close();
    }

    private static Document toInternalDocument(LuceneDocument document) {
        return ((Lucene9Document)document).document;
    }

    private static Iterable<Document> convertDocuments(Iterable<LuceneDocument> documents) {
        return new DocumentIterable(documents.iterator());
    }

    private static class WritableIndexSnapshotFileIterator
    extends ReadOnlyIndexSnapshotFileIterator {
        private final SnapshotDeletionPolicy snapshotDeletionPolicy;
        private final IndexCommit indexCommit;

        WritableIndexSnapshotFileIterator(Path indexDirectory, SnapshotDeletionPolicy snapshotDeletionPolicy) throws IOException {
            this(indexDirectory, snapshotDeletionPolicy, snapshotDeletionPolicy.snapshot());
        }

        private WritableIndexSnapshotFileIterator(Path indexDirectory, SnapshotDeletionPolicy snapshotDeletionPolicy, IndexCommit snapshot) throws IOException {
            super(indexDirectory, snapshot.getFileNames());
            this.snapshotDeletionPolicy = snapshotDeletionPolicy;
            this.indexCommit = snapshot;
        }

        @Override
        public void close() {
            try {
                this.snapshotDeletionPolicy.release(this.indexCommit);
            }
            catch (IOException e) {
                throw new SnapshotReleaseException("Unable to release lucene index snapshot for index in: " + String.valueOf(this.getIndexDirectory()), e);
            }
        }
    }

    private static class DocumentIterable
    implements Iterable<Document> {
        private final Iterator<LuceneDocument> iterator;

        public DocumentIterable(Iterator<LuceneDocument> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Document> iterator() {
            return new Iterator<Document>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Document next() {
                    return Lucene9IndexWriter.toInternalDocument(iterator.next());
                }
            };
        }
    }
}

