/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.partition;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSearcherManager;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class WritableIndexPartition
extends AbstractIndexPartition {
    private final LuceneIndexWriter indexWriter;
    private final LuceneSearcherManager searcherManager;
    private final LuceneDirectoryReader directoryReader;

    public WritableIndexPartition(Path partitionFolder, LuceneDirectory directory, LuceneIndexWriterConfig writerConfig) throws IOException {
        super(partitionFolder, directory);
        this.indexWriter = directory.newWriter(writerConfig);
        this.directoryReader = this.indexWriter.directoryReader();
        this.searcherManager = this.directoryReader.newSearcherManager();
    }

    @Override
    public LuceneIndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public PartitionSearcher acquireSearcher() throws IOException {
        return new PartitionSearcher(this.searcherManager);
    }

    @Override
    public void maybeRefreshBlocking() throws IOException {
        this.searcherManager.maybeRefreshBlocking();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.searcherManager, this.directoryReader, this.indexWriter, this.getDirectory()});
    }

    @Override
    public ResourceIterator<Path> snapshot() throws IOException {
        return this.indexWriter.snapshot(this.partitionFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accessClosedDirectory(ThrowingBiConsumer<Integer, LuceneDirectory, IOException> visitor) throws IOException {
        int numDocs;
        this.indexWriter.close();
        LuceneIndexSearcher searcher = this.searcherManager.acquire();
        try {
            numDocs = searcher.numDocs();
        }
        finally {
            this.searcherManager.close();
        }
        visitor.accept((Object)numDocs, (Object)this.directory);
    }
}

