/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.index.impl.lucene.legacy.AbstractIndexHits;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.lucene.QueryContext;

class TopDocsIterator
extends AbstractIndexHits<Document> {
    private final Iterator<ScoreDoc> iterator;
    private ScoreDoc currentDoc;
    private final int size;
    private final IndexSearcher searcher;

    TopDocsIterator(Query query, QueryContext context, IndexSearcher searcher) throws IOException {
        TopDocs docs = this.toTopDocs(query, context, searcher);
        this.size = docs.scoreDocs.length;
        this.iterator = new ArrayIterator((Object[])docs.scoreDocs);
        this.searcher = searcher;
    }

    private TopDocs toTopDocs(Query query, QueryContext context, IndexSearcher searcher) throws IOException {
        TopDocs topDocs;
        Sort sorting;
        Sort sort = sorting = context != null ? context.getSorting() : null;
        if (sorting == null && context != null) {
            topDocs = searcher.search(query, context.getTop());
        } else if (context == null || !context.getTradeCorrectnessForSpeed()) {
            TopFieldCollector collector = LuceneDataSource.scoringCollector(sorting, context.getTop());
            searcher.search(query, (Collector)collector);
            topDocs = collector.topDocs();
        } else {
            topDocs = searcher.search(query, null, context.getTop(), sorting);
        }
        return topDocs;
    }

    protected Document fetchNextOrNull() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        this.currentDoc = this.iterator.next();
        try {
            return this.searcher.doc(this.currentDoc.doc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public float currentScore() {
        return this.currentDoc.score;
    }

    public int size() {
        return this.size;
    }
}

