/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.store.Directory;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.FailureStorage;
import org.neo4j.kernel.api.impl.index.storage.layout.FolderLayout;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;

public class PartitionedIndexStorage {
    private final DirectoryFactory directoryFactory;
    private final FileSystemAbstraction fileSystem;
    private final FolderLayout folderLayout;
    private final FailureStorage failureStorage;

    public PartitionedIndexStorage(DirectoryFactory directoryFactory, FileSystemAbstraction fileSystem, File rootFolder, String identifier) {
        this.fileSystem = fileSystem;
        this.folderLayout = new IndexFolderLayout(rootFolder, identifier);
        this.directoryFactory = directoryFactory;
        this.failureStorage = new FailureStorage(fileSystem, this.folderLayout);
    }

    public Directory openDirectory(File folder) throws IOException {
        return this.directoryFactory.open(folder);
    }

    public File getPartitionFolder(int partition) {
        return this.folderLayout.getPartitionFolder(partition);
    }

    public File getIndexFolder() {
        return this.folderLayout.getIndexFolder();
    }

    public void reserveIndexFailureStorage() throws IOException {
        this.failureStorage.reserveForIndex();
    }

    public void storeIndexFailure(String failure) throws IOException {
        this.failureStorage.storeIndexFailure(failure);
    }

    public String getStoredIndexFailure() {
        return this.failureStorage.loadIndexFailure();
    }

    public void prepareFolder(File folder) throws IOException {
        this.cleanupFolder(folder);
        this.fileSystem.mkdirs(folder);
    }

    public void cleanupFolder(File folder) throws IOException {
        List<File> partitionFolders = this.listFolders(folder);
        for (File partitionFolder : partitionFolders) {
            this.cleanupLuceneDirectory(partitionFolder);
        }
        this.fileSystem.deleteRecursively(folder);
    }

    public Map<File, Directory> openIndexDirectories() throws IOException {
        LinkedHashMap<File, Directory> directories = new LinkedHashMap<File, Directory>();
        try {
            for (File dir : this.listFolders()) {
                directories.put(dir, this.directoryFactory.open(dir));
            }
        }
        catch (IOException oe) {
            try {
                IOUtils.closeAll(directories.values());
            }
            catch (Exception ce) {
                oe.addSuppressed(ce);
            }
            throw oe;
        }
        return directories;
    }

    public List<File> listFolders() {
        return this.listFolders(this.getIndexFolder());
    }

    private List<File> listFolders(File rootFolder) {
        File[] files = this.fileSystem.listFiles(rootFolder);
        return files == null ? Collections.emptyList() : Stream.of(files).filter(arg_0 -> ((FileSystemAbstraction)this.fileSystem).isDirectory(arg_0)).collect(Collectors.toList());
    }

    private void cleanupLuceneDirectory(File folder) throws IOException {
        try (Directory dir = this.directoryFactory.open(folder);){
            String[] indexFiles;
            for (String indexFile : indexFiles = dir.listAll()) {
                FileUtils.windowsSafeIOOperation(() -> dir.deleteFile(indexFile));
            }
        }
    }
}

