/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class UniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private final int propertyKeyId;
    private final UniqueIndexSampler sampler;

    public UniqueLuceneIndexPopulator(SchemaIndex index, IndexDescriptor descriptor) {
        super(index);
        this.propertyKeyId = descriptor.getPropertyKeyId();
        this.sampler = new UniqueIndexSampler();
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        this.luceneIndex.verifyUniqueness(accessor, this.propertyKeyId);
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new UniqueLuceneIndexPopulatingUpdater(this.writer, this.propertyKeyId, this.luceneIndex, accessor, this.sampler);
    }

    public void includeSample(NodePropertyUpdate update) {
        this.sampler.increment(1L);
    }

    public void configureSampling(boolean onlineSampling) {
    }

    public IndexSample sampleResult() {
        return this.sampler.result();
    }
}

