/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class PartitionedIndexReader
implements IndexReader {
    private final List<SimpleIndexReader> indexReaders;

    public PartitionedIndexReader(List<PartitionSearcher> partitionSearchers, IndexConfiguration indexConfiguration, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this(partitionSearchers.stream().map(partitionSearcher -> new SimpleIndexReader((PartitionSearcher)partitionSearcher, indexConfiguration, samplingConfig, taskCoordinator)).collect(Collectors.toList()));
    }

    PartitionedIndexReader(List<SimpleIndexReader> readers) {
        this.indexReaders = readers;
    }

    public PrimitiveLongIterator seek(Object value) {
        return this.partitionedOperation(reader -> reader.seek(value));
    }

    public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        return this.partitionedOperation(reader -> reader.rangeSeekByNumberInclusive(lower, upper));
    }

    public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        return this.partitionedOperation(reader -> reader.rangeSeekByString(lower, includeLower, upper, includeUpper));
    }

    public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        return this.partitionedOperation(reader -> reader.rangeSeekByPrefix(prefix));
    }

    public PrimitiveLongIterator scan() {
        return this.partitionedOperation(SimpleIndexReader::scan);
    }

    public PrimitiveLongIterator containsString(String exactTerm) {
        return this.partitionedOperation(reader -> reader.containsString(exactTerm));
    }

    public PrimitiveLongIterator endsWith(String suffix) {
        return this.partitionedOperation(reader -> reader.endsWith(suffix));
    }

    public long countIndexedNodes(long nodeId, Object propertyValue) {
        return this.indexReaders.parallelStream().mapToLong(reader -> reader.countIndexedNodes(nodeId, propertyValue)).sum();
    }

    public IndexSampler createSampler() {
        List<IndexSampler> indexSamplers = this.indexReaders.parallelStream().map(SimpleIndexReader::createSampler).collect(Collectors.toList());
        return new AggregatingIndexSampler(indexSamplers);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private PrimitiveLongIterator partitionedOperation(Function<SimpleIndexReader, PrimitiveLongIterator> readerFunction) {
        return PrimitiveLongCollections.concat((Iterable)this.indexReaders.parallelStream().map(readerFunction::apply).collect(Collectors.toList()));
    }
}

