/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;

public class WritableAbstractDatabaseIndex<T extends AbstractLuceneIndex>
implements DatabaseIndex {
    protected final ReentrantLock commitCloseLock = new ReentrantLock();
    protected T luceneIndex;

    public WritableAbstractDatabaseIndex(T luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    @Override
    public void create() throws IOException {
        ((AbstractLuceneIndex)this.luceneIndex).create();
    }

    @Override
    public void open() throws IOException {
        ((AbstractLuceneIndex)this.luceneIndex).open();
    }

    @Override
    public boolean isOpen() {
        return ((AbstractLuceneIndex)this.luceneIndex).isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean exists() throws IOException {
        return ((AbstractLuceneIndex)this.luceneIndex).exists();
    }

    @Override
    public boolean isValid() {
        return ((AbstractLuceneIndex)this.luceneIndex).isValid();
    }

    @Override
    public void drop() throws IOException {
        this.commitCloseLock.lock();
        try {
            ((AbstractLuceneIndex)this.luceneIndex).drop();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.commitCloseLock.lock();
        try {
            ((AbstractLuceneIndex)this.luceneIndex).flush();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.commitCloseLock.lock();
        try {
            ((AbstractLuceneIndex)this.luceneIndex).close();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public LuceneAllDocumentsReader allDocumentsReader() {
        return ((AbstractLuceneIndex)this.luceneIndex).allDocumentsReader();
    }

    @Override
    public ResourceIterator<File> snapshot() throws IOException {
        this.commitCloseLock.lock();
        try {
            ResourceIterator<File> resourceIterator = ((AbstractLuceneIndex)this.luceneIndex).snapshot();
            return resourceIterator;
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void maybeRefreshBlocking() throws IOException {
        ((AbstractLuceneIndex)this.luceneIndex).maybeRefreshBlocking();
    }

    public AbstractIndexPartition addNewPartition() throws IOException {
        return ((AbstractLuceneIndex)this.luceneIndex).addNewPartition();
    }

    @Override
    public List<AbstractIndexPartition> getPartitions() {
        return ((AbstractLuceneIndex)this.luceneIndex).getPartitions();
    }
}

