/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneIndexReaderAcquisitionException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.reader.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;

public class LuceneIndexAccessor
implements IndexAccessor {
    private final LuceneIndexWriter writer;
    private SchemaIndex luceneIndex;

    public LuceneIndexAccessor(SchemaIndex luceneIndex) throws IOException {
        this.luceneIndex = luceneIndex;
        this.writer = luceneIndex.isReadOnly() ? null : luceneIndex.getIndexWriter();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create updated for read only index.");
        }
        switch (mode) {
            case ONLINE: {
                return new LuceneIndexUpdater(this.writer, false);
            }
            case RECOVERY: {
                return new LuceneIndexUpdater(this.writer, true);
            }
        }
        throw new IllegalArgumentException("Unsupported update mode: " + mode);
    }

    public void drop() throws IOException {
        this.luceneIndex.drop();
    }

    public void force() throws IOException {
        this.luceneIndex.markAsOnline();
        this.luceneIndex.maybeRefreshBlocking();
    }

    public void flush() throws IOException {
        this.luceneIndex.maybeRefreshBlocking();
    }

    public void close() throws IOException {
        this.luceneIndex.close();
    }

    public IndexReader newReader() {
        try {
            return this.luceneIndex.getIndexReader();
        }
        catch (IOException e) {
            throw new LuceneIndexReaderAcquisitionException("Can't acquire index reader", e);
        }
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return new LuceneAllEntriesIndexAccessorReader(this.luceneIndex.allDocumentsReader());
    }

    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.luceneIndex.snapshot();
    }

    private class LuceneIndexUpdater
    implements IndexUpdater {
        private final boolean isRecovery;
        private final LuceneIndexWriter writer;

        private LuceneIndexUpdater(LuceneIndexWriter indexWriter, boolean isRecovery) {
            this.isRecovery = isRecovery;
            this.writer = indexWriter;
        }

        public void process(NodePropertyUpdate update) throws IOException {
            switch (update.getUpdateMode()) {
                case ADDED: {
                    if (this.isRecovery) {
                        this.addRecovered(update.getNodeId(), update.getValueAfter());
                        break;
                    }
                    this.add(update.getNodeId(), update.getValueAfter());
                    break;
                }
                case CHANGED: {
                    this.change(update.getNodeId(), update.getValueAfter());
                    break;
                }
                case REMOVED: {
                    this.remove(update.getNodeId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void close() throws IOException, IndexEntryConflictException {
            LuceneIndexAccessor.this.luceneIndex.maybeRefreshBlocking();
        }

        public void remove(PrimitiveLongSet nodeIds) throws IOException {
            nodeIds.visitKeys(nodeId -> {
                this.remove(nodeId);
                return false;
            });
        }

        private void addRecovered(long nodeId, Object value) throws IOException {
            this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperty(nodeId, value));
        }

        private void add(long nodeId, Object value) throws IOException {
            this.writer.addDocument(LuceneDocumentStructure.documentRepresentingProperty(nodeId, value));
        }

        private void change(long nodeId, Object value) throws IOException {
            this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperty(nodeId, value));
        }

        protected void remove(long nodeId) throws IOException {
            this.writer.deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
        }
    }
}

