/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.labelscan.LabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.logging.LogProvider;

public class LuceneLabelScanStoreBuilder {
    private final File storeDir;
    private Supplier<IndexStoreView> storeViewSupplier;
    private final FileSystemAbstraction fileSystem;
    private final Config config;
    private final OperationalMode operationalMode;
    private final LogProvider logProvider;
    private LuceneLabelScanStore labelScanStore;

    public LuceneLabelScanStoreBuilder(File storeDir, IndexStoreView storeView, FileSystemAbstraction fileSystem, Config config, OperationalMode operationalMode, LogProvider logProvider) {
        this(storeDir, () -> storeView, fileSystem, config, operationalMode, logProvider);
    }

    public LuceneLabelScanStoreBuilder(File storeDir, Supplier<IndexStoreView> storeViewSupplier, FileSystemAbstraction fileSystem, Config config, OperationalMode operationalMode, LogProvider logProvider) {
        this.storeDir = storeDir;
        this.storeViewSupplier = storeViewSupplier;
        this.fileSystem = fileSystem;
        this.config = config;
        this.operationalMode = operationalMode;
        this.logProvider = logProvider;
    }

    public LabelScanStore build() {
        if (null == this.labelScanStore) {
            LabelScanIndex index = ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withFileSystem(this.fileSystem)).withIndexRootFolder(LabelScanStoreProvider.getStoreDirectory((File)this.storeDir))).withConfig(this.config)).withOperationalMode(this.operationalMode)).build();
            this.labelScanStore = new LuceneLabelScanStore(index, LabelScanStoreProvider.fullStoreLabelUpdateStream(this.storeViewSupplier), this.logProvider, LuceneLabelScanStore.Monitor.EMPTY);
            try {
                this.labelScanStore.init();
                this.labelScanStore.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.labelScanStore;
    }
}

