/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.partition;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.backup.LuceneIndexSnapshots;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class WritableIndexPartition
extends AbstractIndexPartition {
    private final IndexWriter indexWriter;
    private final SearcherManager searcherManager;

    public WritableIndexPartition(File partitionFolder, Directory directory, IndexWriterConfig writerConfig) throws IOException {
        super(partitionFolder, directory);
        this.indexWriter = new IndexWriter(directory, writerConfig);
        this.searcherManager = new SearcherManager(this.indexWriter, new SearcherFactory());
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public PartitionSearcher acquireSearcher() throws IOException {
        return new PartitionSearcher((ReferenceManager<IndexSearcher>)this.searcherManager);
    }

    @Override
    public void maybeRefreshBlocking() throws IOException {
        this.searcherManager.maybeRefreshBlocking();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.searcherManager, this.indexWriter, this.getDirectory()});
    }

    @Override
    public ResourceIterator<File> snapshot() throws IOException {
        return LuceneIndexSnapshots.forIndex(this.partitionFolder, this.indexWriter);
    }
}

