/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckingCollector;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;

public class CompositeDuplicateCheckingCollector
extends DuplicateCheckingCollector {
    private final int[] propertyKeyIds;

    CompositeDuplicateCheckingCollector(PropertyAccessor accessor, int[] propertyKeyIds) {
        super(accessor, -1);
        this.propertyKeyIds = propertyKeyIds;
    }

    @Override
    protected void doCollect(int doc) throws IOException, KernelException, IndexEntryConflictException {
        Document document = this.reader.document(doc);
        long nodeId = LuceneDocumentStructure.getNodeId(document);
        Property[] properties = new Property[this.propertyKeyIds.length];
        Object[] values = new Object[this.propertyKeyIds.length];
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = this.accessor.getProperty(nodeId, this.propertyKeyIds[i]);
            values[i] = properties[i].value();
        }
        this.duplicateCheckStrategy.checkForDuplicate(properties, values, nodeId);
    }
}

