/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;

abstract class DuplicateCheckStrategy {
    DuplicateCheckStrategy() {
    }

    abstract void checkForDuplicate(Property[] var1, Object[] var2, long var3) throws IndexEntryConflictException;

    abstract void checkForDuplicate(Property var1, Object var2, long var3) throws IndexEntryConflictException;

    private static boolean propertyValuesEqual(Property[] properties, Object[] values) {
        if (properties.length != values.length) {
            return false;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].valueEquals(values[i])) continue;
            return false;
        }
        return true;
    }

    static class BucketsDuplicateCheckStrategy
    extends DuplicateCheckStrategy {
        private static final int BASE_ENTRY_SIZE = 1000;
        private static final int DEFAULT_BUCKETS = 10;
        static final int BUCKET_STRATEGY_ENTRIES_THRESHOLD = 10000;
        private static final int MAX_NUMBER_OF_BUCKETS = 100;
        private final int numberOfBuckets;
        private BucketEntry[] buckets;
        private final int bucketSetSize;

        BucketsDuplicateCheckStrategy() {
            this(10000);
        }

        BucketsDuplicateCheckStrategy(int expectedNumberOfEntries) {
            this.numberOfBuckets = Math.min(100, expectedNumberOfEntries / 1000 + 1);
            this.buckets = new BucketEntry[this.numberOfBuckets];
            this.bucketSetSize = Math.max(100, 10000 / this.numberOfBuckets);
        }

        @Override
        public void checkForDuplicate(Property[] properties, Object[] values, long nodeId) throws IndexEntryConflictException {
            BucketEntry current = this.bucketEntrySet(Arrays.hashCode(values), this.bucketSetSize);
            block0: do {
                for (int i = 0; i < this.bucketSetSize; ++i) {
                    Object[] currentValues = (Object[])current.value[i];
                    if (current.nodeId[i] == -1L) {
                        current.value[i] = values;
                        current.nodeId[i] = nodeId;
                        if (i != this.bucketSetSize - 1) break block0;
                        current.next = new BucketEntry(this.bucketSetSize);
                        break block0;
                    }
                    if (!DuplicateCheckStrategy.propertyValuesEqual(properties, currentValues)) continue;
                    throw new IndexEntryConflictException(current.nodeId[i], nodeId, currentValues);
                }
            } while ((current = current.next) != null);
        }

        @Override
        void checkForDuplicate(Property property, Object propertyValue, long nodeId) throws IndexEntryConflictException {
            BucketEntry current = this.bucketEntrySet(propertyValue.hashCode(), this.bucketSetSize);
            block0: do {
                for (int i = 0; i < this.bucketSetSize; ++i) {
                    Object value = current.value[i];
                    if (current.nodeId[i] == -1L) {
                        current.value[i] = propertyValue;
                        current.nodeId[i] = nodeId;
                        if (i != this.bucketSetSize - 1) break block0;
                        current.next = new BucketEntry(this.bucketSetSize);
                        break block0;
                    }
                    if (!property.valueEquals(value)) continue;
                    throw new IndexEntryConflictException(current.nodeId[i], nodeId, new Object[]{value});
                }
            } while ((current = current.next) != null);
        }

        private BucketEntry bucketEntrySet(int hashCode, int entrySetSize) {
            int bucket = Math.abs(hashCode) % this.numberOfBuckets;
            BucketEntry current = this.buckets[bucket];
            if (current == null) {
                this.buckets[bucket] = current = new BucketEntry(entrySetSize);
            }
            return current;
        }

        private static class BucketEntry {
            final Object[] value;
            final long[] nodeId;
            BucketEntry next;

            BucketEntry(int entrySize) {
                this.value = new Object[entrySize];
                this.nodeId = new long[entrySize];
                Arrays.fill(this.nodeId, -1L);
            }
        }
    }

    static class MapDuplicateCheckStrategy
    extends DuplicateCheckStrategy {
        private Map<Object, Long> valueNodeIdMap;

        MapDuplicateCheckStrategy(int expectedNumberOfEntries) {
            this.valueNodeIdMap = new HashMap<Object, Long>(expectedNumberOfEntries);
        }

        @Override
        public void checkForDuplicate(Property[] properties, Object[] values, long nodeId) throws IndexEntryConflictException {
            Long previousNodeId = this.valueNodeIdMap.put(new PropertyValues(properties, values), nodeId);
            if (previousNodeId != null) {
                throw new IndexEntryConflictException(previousNodeId.longValue(), nodeId, OrderedPropertyValues.ofUndefined((Object[])values));
            }
        }

        @Override
        void checkForDuplicate(Property property, Object value, long nodeId) throws IndexEntryConflictException {
            Long previousNodeId = this.valueNodeIdMap.put(property, nodeId);
            if (previousNodeId != null) {
                throw new IndexEntryConflictException(previousNodeId.longValue(), nodeId, new Object[]{value});
            }
        }

        private static class PropertyValues {
            private final Property[] properties;
            private final Object[] values;

            PropertyValues(Property[] properties, Object[] values) {
                this.properties = properties;
                this.values = values;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PropertyValues that = (PropertyValues)o;
                return DuplicateCheckStrategy.propertyValuesEqual(this.properties, that.values);
            }

            public int hashCode() {
                int result = 0;
                for (Object value : this.values) {
                    result = 31 * (result + value.hashCode());
                }
                return result;
            }
        }
    }
}

