/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.neo4j.helpers.TaskControl;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.sampler.LuceneIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NonUniqueLuceneIndexSampler
extends LuceneIndexSampler {
    private final IndexSearcher indexSearcher;
    private final IndexSamplingConfig indexSamplingConfig;

    public NonUniqueLuceneIndexSampler(IndexSearcher indexSearcher, TaskControl taskControl, IndexSamplingConfig indexSamplingConfig) {
        super(taskControl);
        this.indexSearcher = indexSearcher;
        this.indexSamplingConfig = indexSamplingConfig;
    }

    public IndexSample sampleIndex() throws IndexNotFoundKernelException {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(this.indexSamplingConfig.sampleSizeLimit());
        IndexReader indexReader = this.indexSearcher.getIndexReader();
        for (LeafReaderContext readerContext : indexReader.leaves()) {
            try {
                Set<String> fieldNames = NonUniqueLuceneIndexSampler.getFieldNamesToSample(readerContext);
                for (String fieldName : fieldNames) {
                    BytesRef termsRef;
                    Terms terms = readerContext.reader().terms(fieldName);
                    if (terms == null) continue;
                    TermsEnum termsEnum = LuceneDocumentStructure.originalTerms(terms, fieldName);
                    while ((termsRef = termsEnum.next()) != null) {
                        sampler.include(termsRef.utf8ToString(), (long)termsEnum.docFreq());
                        this.checkCancellation();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return sampler.result(indexReader.numDocs());
    }

    private static Set<String> getFieldNamesToSample(LeafReaderContext readerContext) throws IOException {
        Fields fields = readerContext.reader().fields();
        HashSet<String> fieldNames = new HashSet<String>();
        for (String field : fields) {
            if ("id".equals(field)) continue;
            fieldNames.add(field);
        }
        return fieldNames;
    }
}

