/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.function.Factory;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class LuceneIndexProvider
extends IndexProvider {
    private final IndexStorageFactory indexStorageFactory;
    private final Config config;
    private final OperationalMode operationalMode;
    private final FileSystemAbstraction fileSystem;
    private final IndexProvider.Monitor monitor;

    public LuceneIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode) {
        super(LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR, directoryStructureFactory);
        this.monitor = monitor;
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory);
        this.fileSystem = fileSystem;
        this.config = config;
        this.operationalMode = operationalMode;
    }

    public static IndexDirectoryStructure.Factory defaultDirectoryStructure(File storeDir) {
        return IndexDirectoryStructure.directoriesByProviderKey((File)storeDir);
    }

    protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        return new IndexStorageFactory(directoryFactory, fileSystem, this.directoryStructure());
    }

    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory) {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor, this.config).withFileSystem(this.fileSystem)).withOperationalMode(this.operationalMode)).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(descriptor.getId()))).withWriterConfig((Factory<IndexWriterConfig>)((Factory)IndexWriterConfigs::population)).build();
        if (luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        if (descriptor.type() == IndexDescriptor.Type.UNIQUE) {
            return new UniqueLuceneIndexPopulator(luceneIndex, (IndexDescriptor)descriptor);
        }
        return new NonUniqueLuceneIndexPopulator(luceneIndex, samplingConfig);
    }

    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor, this.config).withOperationalMode(this.operationalMode)).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(descriptor.getId()))).build();
        luceneIndex.open();
        return new LuceneIndexAccessor(luceneIndex, (IndexDescriptor)descriptor);
    }

    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            return this.indexIsOnline(indexStorage, (IndexDescriptor)descriptor) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return IndexCapability.NO_CAPABILITY;
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return new SchemaIndexMigrator(fs, (IndexProvider)this);
    }

    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        String failure = this.getIndexStorage(descriptor.getId()).getStoredIndexFailure();
        if (failure == null) {
            throw new IllegalStateException("Index " + descriptor.getId() + " isn't failed");
        }
        return failure;
    }

    private PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    private boolean indexIsOnline(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor) throws IOException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create(descriptor, this.config).withIndexStorage(indexStorage)).build();){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

