/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckingCollector;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public class CompositeDuplicateCheckingCollector
extends DuplicateCheckingCollector {
    private final int[] propertyKeyIds;

    CompositeDuplicateCheckingCollector(NodePropertyAccessor accessor, int[] propertyKeyIds) {
        super(accessor, -1);
        this.propertyKeyIds = propertyKeyIds;
    }

    @Override
    protected void doCollect(int doc) throws IOException, KernelException, IndexEntryConflictException {
        Document document = this.reader.document(doc);
        long nodeId = LuceneDocumentStructure.getNodeId(document);
        Value[] values = new Value[this.propertyKeyIds.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.accessor.getNodePropertyValue(nodeId, this.propertyKeyIds[i]);
        }
        this.duplicateCheckStrategy.checkForDuplicate(values, nodeId);
    }
}

