/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.util.Iterator;
import java.util.function.ToLongFunction;
import org.apache.lucene.document.Document;
import org.neo4j.helpers.collection.BoundedIterable;

public class LuceneAllEntriesIndexAccessorReader
implements BoundedIterable<Long> {
    private final BoundedIterable<Document> documents;
    private final ToLongFunction<Document> entityIdReader;

    public LuceneAllEntriesIndexAccessorReader(BoundedIterable<Document> documents, ToLongFunction<Document> entityIdReader) {
        this.documents = documents;
        this.entityIdReader = entityIdReader;
    }

    public long maxCount() {
        return this.documents.maxCount();
    }

    public Iterator<Long> iterator() {
        final Iterator iterator = this.documents.iterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Long next() {
                return LuceneAllEntriesIndexAccessorReader.this.entityIdReader.applyAsLong(iterator.next());
            }
        };
    }

    public void close() throws Exception {
        this.documents.close();
    }
}

