/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.AbstractIndexReader;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

public class PartitionedIndexReader
extends AbstractIndexReader {
    private final List<SimpleIndexReader> indexReaders;

    public PartitionedIndexReader(List<PartitionSearcher> partitionSearchers, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this(descriptor, partitionSearchers.stream().map(partitionSearcher -> new SimpleIndexReader((PartitionSearcher)partitionSearcher, descriptor, samplingConfig, taskCoordinator)).collect(Collectors.toList()));
    }

    PartitionedIndexReader(IndexDescriptor descriptor, List<SimpleIndexReader> readers) {
        super(descriptor);
        this.indexReaders = readers;
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        try {
            return this.partitionedOperation(reader -> this.innerQuery((IndexReader)reader, predicates));
        }
        catch (InnerException e) {
            throw e.getCause();
        }
    }

    public void query(IndexProgressor.NodeValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) throws IndexNotApplicableKernelException {
        try {
            BridgingIndexProgressor bridgingIndexProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            this.indexReaders.parallelStream().forEach(reader -> {
                try {
                    reader.query((IndexProgressor.NodeValueClient)bridgingIndexProgressor, indexOrder, needsValues, query);
                }
                catch (IndexNotApplicableKernelException e) {
                    throw new InnerException(e);
                }
            });
            client.initialize(this.descriptor, (IndexProgressor)bridgingIndexProgressor, query, indexOrder, needsValues);
        }
        catch (InnerException e) {
            throw e.getCause();
        }
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    public void distinctValues(IndexProgressor.NodeValueClient client, NodePropertyAccessor propertyAccessor, boolean needsValues) {
        BridgingIndexProgressor bridgingIndexProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
        this.indexReaders.parallelStream().forEach(reader -> reader.distinctValues((IndexProgressor.NodeValueClient)bridgingIndexProgressor, propertyAccessor, needsValues));
        client.initialize(this.descriptor, (IndexProgressor)bridgingIndexProgressor, new IndexQuery[0], IndexOrder.NONE, needsValues);
    }

    private PrimitiveLongResourceIterator innerQuery(IndexReader reader, IndexQuery[] predicates) {
        try {
            return reader.query(predicates);
        }
        catch (IndexNotApplicableKernelException e) {
            throw new InnerException(e);
        }
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        return this.indexReaders.parallelStream().mapToLong(reader -> reader.countIndexedNodes(nodeId, propertyKeyIds, propertyValues)).sum();
    }

    public IndexSampler createSampler() {
        List<IndexSampler> indexSamplers = this.indexReaders.parallelStream().map(SimpleIndexReader::createSampler).collect(Collectors.toList());
        return new AggregatingIndexSampler(indexSamplers);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private PrimitiveLongResourceIterator partitionedOperation(Function<SimpleIndexReader, PrimitiveLongResourceIterator> readerFunction) {
        return PrimitiveLongResourceCollections.concat((Iterable)this.indexReaders.parallelStream().map(readerFunction).collect(Collectors.toList()));
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super((Throwable)e);
        }

        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

